package io.fabric8.kubernetes.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class KeyToPathBuilder extends KeyToPathFluentImpl<KeyToPathBuilder> implements VisitableBuilder<KeyToPath,KeyToPathBuilder>{

    KeyToPathFluent<?> fluent;
    Boolean validationEnabled;

    public KeyToPathBuilder(){
            this(true);
    }
    public KeyToPathBuilder(Boolean validationEnabled){
            this(new KeyToPath(), validationEnabled);
    }
    public KeyToPathBuilder(KeyToPathFluent<?> fluent){
            this(fluent, true);
    }
    public KeyToPathBuilder(KeyToPathFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KeyToPath(), validationEnabled);
    }
    public KeyToPathBuilder(KeyToPathFluent<?> fluent,KeyToPath instance){
            this(fluent, instance, true);
    }
    public KeyToPathBuilder(KeyToPathFluent<?> fluent,KeyToPath instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withKey(instance.getKey()); 
            fluent.withPath(instance.getPath()); 
            this.validationEnabled = validationEnabled; 
    }
    public KeyToPathBuilder(KeyToPath instance){
            this(instance,true);
    }
    public KeyToPathBuilder(KeyToPath instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withKey(instance.getKey()); 
            this.withPath(instance.getPath()); 
            this.validationEnabled = validationEnabled; 
    }

    public KeyToPath build(){
            KeyToPath buildable = new KeyToPath(fluent.getKey(),fluent.getPath());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KeyToPathBuilder that = (KeyToPathBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
