package io.fabric8.kubernetes.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class EndpointPortBuilder extends EndpointPortFluentImpl<EndpointPortBuilder> implements VisitableBuilder<EndpointPort,EndpointPortBuilder>{

    EndpointPortFluent<?> fluent;
    Boolean validationEnabled;

    public EndpointPortBuilder(){
            this(true);
    }
    public EndpointPortBuilder(Boolean validationEnabled){
            this(new EndpointPort(), validationEnabled);
    }
    public EndpointPortBuilder(EndpointPortFluent<?> fluent){
            this(fluent, true);
    }
    public EndpointPortBuilder(EndpointPortFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new EndpointPort(), validationEnabled);
    }
    public EndpointPortBuilder(EndpointPortFluent<?> fluent,EndpointPort instance){
            this(fluent, instance, true);
    }
    public EndpointPortBuilder(EndpointPortFluent<?> fluent,EndpointPort instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withPort(instance.getPort()); 
            fluent.withProtocol(instance.getProtocol()); 
            this.validationEnabled = validationEnabled; 
    }
    public EndpointPortBuilder(EndpointPort instance){
            this(instance,true);
    }
    public EndpointPortBuilder(EndpointPort instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withPort(instance.getPort()); 
            this.withProtocol(instance.getProtocol()); 
            this.validationEnabled = validationEnabled; 
    }

    public EndpointPort build(){
            EndpointPort buildable = new EndpointPort(fluent.getName(),fluent.getPort(),fluent.getProtocol());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EndpointPortBuilder that = (EndpointPortBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
