package io.fabric8.kubernetes.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class DownwardAPIVolumeSourceBuilder extends DownwardAPIVolumeSourceFluentImpl<DownwardAPIVolumeSourceBuilder> implements VisitableBuilder<DownwardAPIVolumeSource,DownwardAPIVolumeSourceBuilder>{

    DownwardAPIVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public DownwardAPIVolumeSourceBuilder(){
            this(true);
    }
    public DownwardAPIVolumeSourceBuilder(Boolean validationEnabled){
            this(new DownwardAPIVolumeSource(), validationEnabled);
    }
    public DownwardAPIVolumeSourceBuilder(DownwardAPIVolumeSourceFluent<?> fluent){
            this(fluent, true);
    }
    public DownwardAPIVolumeSourceBuilder(DownwardAPIVolumeSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DownwardAPIVolumeSource(), validationEnabled);
    }
    public DownwardAPIVolumeSourceBuilder(DownwardAPIVolumeSourceFluent<?> fluent,DownwardAPIVolumeSource instance){
            this(fluent, instance, true);
    }
    public DownwardAPIVolumeSourceBuilder(DownwardAPIVolumeSourceFluent<?> fluent,DownwardAPIVolumeSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withItems(instance.getItems()); 
            this.validationEnabled = validationEnabled; 
    }
    public DownwardAPIVolumeSourceBuilder(DownwardAPIVolumeSource instance){
            this(instance,true);
    }
    public DownwardAPIVolumeSourceBuilder(DownwardAPIVolumeSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withItems(instance.getItems()); 
            this.validationEnabled = validationEnabled; 
    }

    public DownwardAPIVolumeSource build(){
            DownwardAPIVolumeSource buildable = new DownwardAPIVolumeSource(fluent.getItems());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DownwardAPIVolumeSourceBuilder that = (DownwardAPIVolumeSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
