package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface ComponentStatusFluent<A extends ComponentStatusFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToConditions(ComponentCondition... items);
    public A removeFromConditions(ComponentCondition... items);
    public List<ComponentCondition> getConditions();
    public A withConditions(List<ComponentCondition> conditions);
    public A withConditions(ComponentCondition... conditions);
    public ComponentStatusFluent.ConditionsNested<A> addNewCondition();
    public ComponentStatusFluent.ConditionsNested<A> addNewConditionLike(ComponentCondition item);
    public A addNewCondition(String error,String message,String status,String type);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public ComponentStatusFluent.MetadataNested<A> withNewMetadata();
    public ComponentStatusFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ComponentStatusFluent.MetadataNested<A> editMetadata();
    public ComponentStatusFluent.MetadataNested<A> editOrNewMetadata();
    public ComponentStatusFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);

    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ComponentConditionFluent<ComponentStatusFluent.ConditionsNested<N>>{

        
    public N and();    public N endCondition();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ComponentStatusFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
