package io.fabric8.kubernetes.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class CephFSVolumeSourceBuilder extends CephFSVolumeSourceFluentImpl<CephFSVolumeSourceBuilder> implements VisitableBuilder<CephFSVolumeSource,CephFSVolumeSourceBuilder>{

    CephFSVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public CephFSVolumeSourceBuilder(){
            this(true);
    }
    public CephFSVolumeSourceBuilder(Boolean validationEnabled){
            this(new CephFSVolumeSource(), validationEnabled);
    }
    public CephFSVolumeSourceBuilder(CephFSVolumeSourceFluent<?> fluent){
            this(fluent, true);
    }
    public CephFSVolumeSourceBuilder(CephFSVolumeSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CephFSVolumeSource(), validationEnabled);
    }
    public CephFSVolumeSourceBuilder(CephFSVolumeSourceFluent<?> fluent,CephFSVolumeSource instance){
            this(fluent, instance, true);
    }
    public CephFSVolumeSourceBuilder(CephFSVolumeSourceFluent<?> fluent,CephFSVolumeSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMonitors(instance.getMonitors()); 
            fluent.withPath(instance.getPath()); 
            fluent.withReadOnly(instance.getReadOnly()); 
            fluent.withSecretFile(instance.getSecretFile()); 
            fluent.withSecretRef(instance.getSecretRef()); 
            fluent.withUser(instance.getUser()); 
            this.validationEnabled = validationEnabled; 
    }
    public CephFSVolumeSourceBuilder(CephFSVolumeSource instance){
            this(instance,true);
    }
    public CephFSVolumeSourceBuilder(CephFSVolumeSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMonitors(instance.getMonitors()); 
            this.withPath(instance.getPath()); 
            this.withReadOnly(instance.getReadOnly()); 
            this.withSecretFile(instance.getSecretFile()); 
            this.withSecretRef(instance.getSecretRef()); 
            this.withUser(instance.getUser()); 
            this.validationEnabled = validationEnabled; 
    }

    public CephFSVolumeSource build(){
            CephFSVolumeSource buildable = new CephFSVolumeSource(fluent.getMonitors(),fluent.getPath(),fluent.isReadOnly(),fluent.getSecretFile(),fluent.getSecretRef(),fluent.getUser());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CephFSVolumeSourceBuilder that = (CephFSVolumeSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
