package io.fabric8.openshift.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class WebHookTriggerBuilder extends WebHookTriggerFluentImpl<WebHookTriggerBuilder> implements VisitableBuilder<WebHookTrigger,WebHookTriggerBuilder>{

    WebHookTriggerFluent<?> fluent;
    Boolean validationEnabled;

    public WebHookTriggerBuilder(){
            this(true);
    }
    public WebHookTriggerBuilder(Boolean validationEnabled){
            this(new WebHookTrigger(), validationEnabled);
    }
    public WebHookTriggerBuilder(WebHookTriggerFluent<?> fluent){
            this(fluent, true);
    }
    public WebHookTriggerBuilder(WebHookTriggerFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new WebHookTrigger(), validationEnabled);
    }
    public WebHookTriggerBuilder(WebHookTriggerFluent<?> fluent,WebHookTrigger instance){
            this(fluent, instance, true);
    }
    public WebHookTriggerBuilder(WebHookTriggerFluent<?> fluent,WebHookTrigger instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAllowEnv(instance.getAllowEnv()); 
            fluent.withSecret(instance.getSecret()); 
            this.validationEnabled = validationEnabled; 
    }
    public WebHookTriggerBuilder(WebHookTrigger instance){
            this(instance,true);
    }
    public WebHookTriggerBuilder(WebHookTrigger instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAllowEnv(instance.getAllowEnv()); 
            this.withSecret(instance.getSecret()); 
            this.validationEnabled = validationEnabled; 
    }

    public WebHookTrigger build(){
            WebHookTrigger buildable = new WebHookTrigger(fluent.isAllowEnv(),fluent.getSecret());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            WebHookTriggerBuilder that = (WebHookTriggerBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
