package io.fabric8.openshift.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class TagReferenceBuilder extends TagReferenceFluentImpl<TagReferenceBuilder> implements VisitableBuilder<TagReference,TagReferenceBuilder>{

    TagReferenceFluent<?> fluent;
    Boolean validationEnabled;

    public TagReferenceBuilder(){
            this(true);
    }
    public TagReferenceBuilder(Boolean validationEnabled){
            this(new TagReference(), validationEnabled);
    }
    public TagReferenceBuilder(TagReferenceFluent<?> fluent){
            this(fluent, true);
    }
    public TagReferenceBuilder(TagReferenceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TagReference(), validationEnabled);
    }
    public TagReferenceBuilder(TagReferenceFluent<?> fluent,TagReference instance){
            this(fluent, instance, true);
    }
    public TagReferenceBuilder(TagReferenceFluent<?> fluent,TagReference instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAnnotations(instance.getAnnotations()); 
            fluent.withFrom(instance.getFrom()); 
            fluent.withGeneration(instance.getGeneration()); 
            fluent.withImportPolicy(instance.getImportPolicy()); 
            fluent.withName(instance.getName()); 
            fluent.withReference(instance.getReference()); 
            this.validationEnabled = validationEnabled; 
    }
    public TagReferenceBuilder(TagReference instance){
            this(instance,true);
    }
    public TagReferenceBuilder(TagReference instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAnnotations(instance.getAnnotations()); 
            this.withFrom(instance.getFrom()); 
            this.withGeneration(instance.getGeneration()); 
            this.withImportPolicy(instance.getImportPolicy()); 
            this.withName(instance.getName()); 
            this.withReference(instance.getReference()); 
            this.validationEnabled = validationEnabled; 
    }

    public TagReference build(){
            TagReference buildable = new TagReference(fluent.getAnnotations(),fluent.getFrom(),fluent.getGeneration(),fluent.getImportPolicy(),fluent.getName(),fluent.isReference());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TagReferenceBuilder that = (TagReferenceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
