package io.fabric8.openshift.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class TagEventBuilder extends TagEventFluentImpl<TagEventBuilder> implements VisitableBuilder<TagEvent,TagEventBuilder>{

    TagEventFluent<?> fluent;
    Boolean validationEnabled;

    public TagEventBuilder(){
            this(true);
    }
    public TagEventBuilder(Boolean validationEnabled){
            this(new TagEvent(), validationEnabled);
    }
    public TagEventBuilder(TagEventFluent<?> fluent){
            this(fluent, true);
    }
    public TagEventBuilder(TagEventFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TagEvent(), validationEnabled);
    }
    public TagEventBuilder(TagEventFluent<?> fluent,TagEvent instance){
            this(fluent, instance, true);
    }
    public TagEventBuilder(TagEventFluent<?> fluent,TagEvent instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCreated(instance.getCreated()); 
            fluent.withDockerImageReference(instance.getDockerImageReference()); 
            fluent.withGeneration(instance.getGeneration()); 
            fluent.withImage(instance.getImage()); 
            this.validationEnabled = validationEnabled; 
    }
    public TagEventBuilder(TagEvent instance){
            this(instance,true);
    }
    public TagEventBuilder(TagEvent instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCreated(instance.getCreated()); 
            this.withDockerImageReference(instance.getDockerImageReference()); 
            this.withGeneration(instance.getGeneration()); 
            this.withImage(instance.getImage()); 
            this.validationEnabled = validationEnabled; 
    }

    public TagEvent build(){
            TagEvent buildable = new TagEvent(fluent.getCreated(),fluent.getDockerImageReference(),fluent.getGeneration(),fluent.getImage());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TagEventBuilder that = (TagEventBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
