package io.fabric8.openshift.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class SourceControlUserBuilder extends SourceControlUserFluentImpl<SourceControlUserBuilder> implements VisitableBuilder<SourceControlUser,SourceControlUserBuilder>{

    SourceControlUserFluent<?> fluent;
    Boolean validationEnabled;

    public SourceControlUserBuilder(){
            this(true);
    }
    public SourceControlUserBuilder(Boolean validationEnabled){
            this(new SourceControlUser(), validationEnabled);
    }
    public SourceControlUserBuilder(SourceControlUserFluent<?> fluent){
            this(fluent, true);
    }
    public SourceControlUserBuilder(SourceControlUserFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SourceControlUser(), validationEnabled);
    }
    public SourceControlUserBuilder(SourceControlUserFluent<?> fluent,SourceControlUser instance){
            this(fluent, instance, true);
    }
    public SourceControlUserBuilder(SourceControlUserFluent<?> fluent,SourceControlUser instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withEmail(instance.getEmail()); 
            fluent.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public SourceControlUserBuilder(SourceControlUser instance){
            this(instance,true);
    }
    public SourceControlUserBuilder(SourceControlUser instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withEmail(instance.getEmail()); 
            this.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }

    public SourceControlUser build(){
            SourceControlUser buildable = new SourceControlUser(fluent.getEmail(),fluent.getName());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SourceControlUserBuilder that = (SourceControlUserBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
