package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class RouteStatusFluentImpl<A extends RouteStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RouteStatusFluent<A>{

    private List<VisitableBuilder<? extends RouteIngress,?>> ingress =  new ArrayList<VisitableBuilder<? extends RouteIngress,?>>();

    public RouteStatusFluentImpl(){
    }
    public RouteStatusFluentImpl(RouteStatus instance){
            this.withIngress(instance.getIngress()); 
    }

    public A addToIngress(RouteIngress... items){
            for (RouteIngress item : items) {RouteIngressBuilder builder = new RouteIngressBuilder(item);_visitables.add(builder);this.ingress.add(builder);} return (A)this;
    }

    public A removeFromIngress(RouteIngress... items){
            for (RouteIngress item : items) {RouteIngressBuilder builder = new RouteIngressBuilder(item);_visitables.remove(builder);this.ingress.remove(builder);} return (A)this;
    }

    public List<RouteIngress> getIngress(){
            return build(ingress);
    }

    public A withIngress(List<RouteIngress> ingress){
            _visitables.removeAll(this.ingress);
            this.ingress.clear();
            if (ingress != null) {for (RouteIngress item : ingress){this.addToIngress(item);}} return (A) this;
    }

    public A withIngress(RouteIngress... ingress){
            this.ingress.clear(); if (ingress != null) {for (RouteIngress item :ingress){ this.addToIngress(item);}} return (A) this;
    }

    public RouteStatusFluent.IngressNested<A> addNewIngress(){
            return new IngressNestedImpl();
    }

    public RouteStatusFluent.IngressNested<A> addNewIngressLike(RouteIngress item){
            return new IngressNestedImpl(item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RouteStatusFluentImpl that = (RouteStatusFluentImpl) o;
            if (ingress != null ? !ingress.equals(that.ingress) :that.ingress != null) return false;
            return true;
    }


    public class IngressNestedImpl<N> extends RouteIngressFluentImpl<RouteStatusFluent.IngressNested<N>> implements RouteStatusFluent.IngressNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RouteIngressBuilder builder;
    
            IngressNestedImpl(RouteIngress item){
                    this.builder = new RouteIngressBuilder(this, item);
            }
            IngressNestedImpl(){
                    this.builder = new RouteIngressBuilder(this);
            }
    
    public N and(){
            return (N) RouteStatusFluentImpl.this.addToIngress(builder.build());
    }
    public N endIngress(){
            return and();
    }

}


}
