package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface ProjectFluent<A extends ProjectFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public ProjectFluent.MetadataNested<A> withNewMetadata();
    public ProjectFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ProjectFluent.MetadataNested<A> editMetadata();
    public ProjectFluent.MetadataNested<A> editOrNewMetadata();
    public ProjectFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public ProjectSpec getSpec();
    public A withSpec(ProjectSpec spec);
    public ProjectFluent.SpecNested<A> withNewSpec();
    public ProjectFluent.SpecNested<A> withNewSpecLike(ProjectSpec item);
    public ProjectFluent.SpecNested<A> editSpec();
    public ProjectFluent.SpecNested<A> editOrNewSpec();
    public ProjectFluent.SpecNested<A> editOrNewSpecLike(ProjectSpec item);
    public ProjectStatus getStatus();
    public A withStatus(ProjectStatus status);
    public ProjectFluent.StatusNested<A> withNewStatus();
    public ProjectFluent.StatusNested<A> withNewStatusLike(ProjectStatus item);
    public ProjectFluent.StatusNested<A> editStatus();
    public ProjectFluent.StatusNested<A> editOrNewStatus();
    public ProjectFluent.StatusNested<A> editOrNewStatusLike(ProjectStatus item);
    public A withNewStatus(String phase);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ProjectFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProjectSpecFluent<ProjectFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProjectStatusFluent<ProjectFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
