package io.fabric8.openshift.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class JenkinsPipelineBuildStrategyBuilder extends JenkinsPipelineBuildStrategyFluentImpl<JenkinsPipelineBuildStrategyBuilder> implements VisitableBuilder<JenkinsPipelineBuildStrategy,JenkinsPipelineBuildStrategyBuilder>{

    JenkinsPipelineBuildStrategyFluent<?> fluent;
    Boolean validationEnabled;

    public JenkinsPipelineBuildStrategyBuilder(){
            this(true);
    }
    public JenkinsPipelineBuildStrategyBuilder(Boolean validationEnabled){
            this(new JenkinsPipelineBuildStrategy(), validationEnabled);
    }
    public JenkinsPipelineBuildStrategyBuilder(JenkinsPipelineBuildStrategyFluent<?> fluent){
            this(fluent, true);
    }
    public JenkinsPipelineBuildStrategyBuilder(JenkinsPipelineBuildStrategyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new JenkinsPipelineBuildStrategy(), validationEnabled);
    }
    public JenkinsPipelineBuildStrategyBuilder(JenkinsPipelineBuildStrategyFluent<?> fluent,JenkinsPipelineBuildStrategy instance){
            this(fluent, instance, true);
    }
    public JenkinsPipelineBuildStrategyBuilder(JenkinsPipelineBuildStrategyFluent<?> fluent,JenkinsPipelineBuildStrategy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withJenkinsfile(instance.getJenkinsfile()); 
            fluent.withJenkinsfilePath(instance.getJenkinsfilePath()); 
            this.validationEnabled = validationEnabled; 
    }
    public JenkinsPipelineBuildStrategyBuilder(JenkinsPipelineBuildStrategy instance){
            this(instance,true);
    }
    public JenkinsPipelineBuildStrategyBuilder(JenkinsPipelineBuildStrategy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withJenkinsfile(instance.getJenkinsfile()); 
            this.withJenkinsfilePath(instance.getJenkinsfilePath()); 
            this.validationEnabled = validationEnabled; 
    }

    public JenkinsPipelineBuildStrategy build(){
            JenkinsPipelineBuildStrategy buildable = new JenkinsPipelineBuildStrategy(fluent.getJenkinsfile(),fluent.getJenkinsfilePath());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            JenkinsPipelineBuildStrategyBuilder that = (JenkinsPipelineBuildStrategyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
