package io.fabric8.openshift.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class ImageSourceBuilder extends ImageSourceFluentImpl<ImageSourceBuilder> implements VisitableBuilder<ImageSource,ImageSourceBuilder>{

    ImageSourceFluent<?> fluent;
    Boolean validationEnabled;

    public ImageSourceBuilder(){
            this(true);
    }
    public ImageSourceBuilder(Boolean validationEnabled){
            this(new ImageSource(), validationEnabled);
    }
    public ImageSourceBuilder(ImageSourceFluent<?> fluent){
            this(fluent, true);
    }
    public ImageSourceBuilder(ImageSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ImageSource(), validationEnabled);
    }
    public ImageSourceBuilder(ImageSourceFluent<?> fluent,ImageSource instance){
            this(fluent, instance, true);
    }
    public ImageSourceBuilder(ImageSourceFluent<?> fluent,ImageSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withFrom(instance.getFrom()); 
            fluent.withPaths(instance.getPaths()); 
            fluent.withPullSecret(instance.getPullSecret()); 
            this.validationEnabled = validationEnabled; 
    }
    public ImageSourceBuilder(ImageSource instance){
            this(instance,true);
    }
    public ImageSourceBuilder(ImageSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withFrom(instance.getFrom()); 
            this.withPaths(instance.getPaths()); 
            this.withPullSecret(instance.getPullSecret()); 
            this.validationEnabled = validationEnabled; 
    }

    public ImageSource build(){
            ImageSource buildable = new ImageSource(fluent.getFrom(),fluent.getPaths(),fluent.getPullSecret());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ImageSourceBuilder that = (ImageSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
