package io.fabric8.openshift.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class GitHubWebHookCauseBuilder extends GitHubWebHookCauseFluentImpl<GitHubWebHookCauseBuilder> implements VisitableBuilder<GitHubWebHookCause,GitHubWebHookCauseBuilder>{

    GitHubWebHookCauseFluent<?> fluent;
    Boolean validationEnabled;

    public GitHubWebHookCauseBuilder(){
            this(true);
    }
    public GitHubWebHookCauseBuilder(Boolean validationEnabled){
            this(new GitHubWebHookCause(), validationEnabled);
    }
    public GitHubWebHookCauseBuilder(GitHubWebHookCauseFluent<?> fluent){
            this(fluent, true);
    }
    public GitHubWebHookCauseBuilder(GitHubWebHookCauseFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new GitHubWebHookCause(), validationEnabled);
    }
    public GitHubWebHookCauseBuilder(GitHubWebHookCauseFluent<?> fluent,GitHubWebHookCause instance){
            this(fluent, instance, true);
    }
    public GitHubWebHookCauseBuilder(GitHubWebHookCauseFluent<?> fluent,GitHubWebHookCause instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRevision(instance.getRevision()); 
            fluent.withSecret(instance.getSecret()); 
            this.validationEnabled = validationEnabled; 
    }
    public GitHubWebHookCauseBuilder(GitHubWebHookCause instance){
            this(instance,true);
    }
    public GitHubWebHookCauseBuilder(GitHubWebHookCause instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRevision(instance.getRevision()); 
            this.withSecret(instance.getSecret()); 
            this.validationEnabled = validationEnabled; 
    }

    public GitHubWebHookCause build(){
            GitHubWebHookCause buildable = new GitHubWebHookCause(fluent.getRevision(),fluent.getSecret());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            GitHubWebHookCauseBuilder that = (GitHubWebHookCauseBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
