package io.fabric8.openshift.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class ExecNewPodHookBuilder extends ExecNewPodHookFluentImpl<ExecNewPodHookBuilder> implements VisitableBuilder<ExecNewPodHook,ExecNewPodHookBuilder>{

    ExecNewPodHookFluent<?> fluent;
    Boolean validationEnabled;

    public ExecNewPodHookBuilder(){
            this(true);
    }
    public ExecNewPodHookBuilder(Boolean validationEnabled){
            this(new ExecNewPodHook(), validationEnabled);
    }
    public ExecNewPodHookBuilder(ExecNewPodHookFluent<?> fluent){
            this(fluent, true);
    }
    public ExecNewPodHookBuilder(ExecNewPodHookFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExecNewPodHook(), validationEnabled);
    }
    public ExecNewPodHookBuilder(ExecNewPodHookFluent<?> fluent,ExecNewPodHook instance){
            this(fluent, instance, true);
    }
    public ExecNewPodHookBuilder(ExecNewPodHookFluent<?> fluent,ExecNewPodHook instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCommand(instance.getCommand()); 
            fluent.withContainerName(instance.getContainerName()); 
            fluent.withEnv(instance.getEnv()); 
            fluent.withVolumes(instance.getVolumes()); 
            this.validationEnabled = validationEnabled; 
    }
    public ExecNewPodHookBuilder(ExecNewPodHook instance){
            this(instance,true);
    }
    public ExecNewPodHookBuilder(ExecNewPodHook instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCommand(instance.getCommand()); 
            this.withContainerName(instance.getContainerName()); 
            this.withEnv(instance.getEnv()); 
            this.withVolumes(instance.getVolumes()); 
            this.validationEnabled = validationEnabled; 
    }

    public ExecNewPodHook build(){
            ExecNewPodHook buildable = new ExecNewPodHook(fluent.getCommand(),fluent.getContainerName(),fluent.getEnv(),fluent.getVolumes());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExecNewPodHookBuilder that = (ExecNewPodHookBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
