package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Integer;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface DeploymentConfigSpecFluent<A extends DeploymentConfigSpecFluent<A>> extends Fluent<A>{


    public Integer getMinReadySeconds();
    public A withMinReadySeconds(Integer minReadySeconds);
    public Boolean isPaused();
    public A withPaused(Boolean paused);
    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Integer getRevisionHistoryLimit();
    public A withRevisionHistoryLimit(Integer revisionHistoryLimit);
    public A addToSelector(String key,String value);
    public A addToSelector(Map<String,String> map);
    public A removeFromSelector(String key);
    public A removeFromSelector(Map<String,String> map);
    public Map<String,String> getSelector();
    public A withSelector(Map<String,String> selector);
    public io.fabric8.openshift.api.model.DeploymentStrategy getStrategy();
    public A withStrategy(io.fabric8.openshift.api.model.DeploymentStrategy strategy);
    public DeploymentConfigSpecFluent.ModelStrategyNested<A> withNewModelStrategy();
    public DeploymentConfigSpecFluent.ModelStrategyNested<A> withNewStrategyLike(io.fabric8.openshift.api.model.DeploymentStrategy item);
    public DeploymentConfigSpecFluent.ModelStrategyNested<A> editModelStrategy();
    public DeploymentConfigSpecFluent.ModelStrategyNested<A> editOrNewStrategy();
    public DeploymentConfigSpecFluent.ModelStrategyNested<A> editOrNewStrategyLike(io.fabric8.openshift.api.model.DeploymentStrategy item);
    public PodTemplateSpec getTemplate();
    public A withTemplate(PodTemplateSpec template);
    public DeploymentConfigSpecFluent.TemplateNested<A> withNewTemplate();
    public DeploymentConfigSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item);
    public DeploymentConfigSpecFluent.TemplateNested<A> editTemplate();
    public DeploymentConfigSpecFluent.TemplateNested<A> editOrNewTemplate();
    public DeploymentConfigSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item);
    public Boolean isTest();
    public A withTest(Boolean test);
    public A addToTriggers(DeploymentTriggerPolicy... items);
    public A removeFromTriggers(DeploymentTriggerPolicy... items);
    public List<DeploymentTriggerPolicy> getTriggers();
    public A withTriggers(List<DeploymentTriggerPolicy> triggers);
    public A withTriggers(DeploymentTriggerPolicy... triggers);
    public DeploymentConfigSpecFluent.TriggersNested<A> addNewTrigger();
    public DeploymentConfigSpecFluent.TriggersNested<A> addNewTriggerLike(DeploymentTriggerPolicy item);

    public interface ModelStrategyNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.DeploymentStrategyFluent<DeploymentConfigSpecFluent.ModelStrategyNested<N>>{

        
    public N and();    public N endModelStrategy();
}
    public interface TemplateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodTemplateSpecFluent<DeploymentConfigSpecFluent.TemplateNested<N>>{

        
    public N and();    public N endTemplate();
}
    public interface TriggersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DeploymentTriggerPolicyFluent<DeploymentConfigSpecFluent.TriggersNested<N>>{

        
    public N and();    public N endTrigger();
}


}
