package io.fabric8.openshift.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class ClusterRoleBindingBuilder extends ClusterRoleBindingFluentImpl<ClusterRoleBindingBuilder> implements VisitableBuilder<ClusterRoleBinding,ClusterRoleBindingBuilder>{

    ClusterRoleBindingFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterRoleBindingBuilder(){
            this(true);
    }
    public ClusterRoleBindingBuilder(Boolean validationEnabled){
            this(new ClusterRoleBinding(), validationEnabled);
    }
    public ClusterRoleBindingBuilder(ClusterRoleBindingFluent<?> fluent){
            this(fluent, true);
    }
    public ClusterRoleBindingBuilder(ClusterRoleBindingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ClusterRoleBinding(), validationEnabled);
    }
    public ClusterRoleBindingBuilder(ClusterRoleBindingFluent<?> fluent,ClusterRoleBinding instance){
            this(fluent, instance, true);
    }
    public ClusterRoleBindingBuilder(ClusterRoleBindingFluent<?> fluent,ClusterRoleBinding instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withGroupNames(instance.getGroupNames()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withRoleRef(instance.getRoleRef()); 
            fluent.withSubjects(instance.getSubjects()); 
            fluent.withUserNames(instance.getUserNames()); 
            this.validationEnabled = validationEnabled; 
    }
    public ClusterRoleBindingBuilder(ClusterRoleBinding instance){
            this(instance,true);
    }
    public ClusterRoleBindingBuilder(ClusterRoleBinding instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withGroupNames(instance.getGroupNames()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withRoleRef(instance.getRoleRef()); 
            this.withSubjects(instance.getSubjects()); 
            this.withUserNames(instance.getUserNames()); 
            this.validationEnabled = validationEnabled; 
    }

    public ClusterRoleBinding build(){
            ClusterRoleBinding buildable = new ClusterRoleBinding(fluent.getApiVersion(),fluent.getGroupNames(),fluent.getKind(),fluent.getMetadata(),fluent.getRoleRef(),fluent.getSubjects(),fluent.getUserNames());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ClusterRoleBindingBuilder that = (ClusterRoleBindingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
