package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface BuildFluent<A extends BuildFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public BuildFluent.MetadataNested<A> withNewMetadata();
    public BuildFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public BuildFluent.MetadataNested<A> editMetadata();
    public BuildFluent.MetadataNested<A> editOrNewMetadata();
    public BuildFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public BuildSpec getSpec();
    public A withSpec(BuildSpec spec);
    public BuildFluent.SpecNested<A> withNewSpec();
    public BuildFluent.SpecNested<A> withNewSpecLike(BuildSpec item);
    public BuildFluent.SpecNested<A> editSpec();
    public BuildFluent.SpecNested<A> editOrNewSpec();
    public BuildFluent.SpecNested<A> editOrNewSpecLike(BuildSpec item);
    public BuildStatus getStatus();
    public A withStatus(BuildStatus status);
    public BuildFluent.StatusNested<A> withNewStatus();
    public BuildFluent.StatusNested<A> withNewStatusLike(BuildStatus item);
    public BuildFluent.StatusNested<A> editStatus();
    public BuildFluent.StatusNested<A> editOrNewStatus();
    public BuildFluent.StatusNested<A> editOrNewStatusLike(BuildStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<BuildFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildSpecFluent<BuildFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildStatusFluent<BuildFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
