package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class IngressBackendBuilder extends IngressBackendFluentImpl<IngressBackendBuilder> implements VisitableBuilder<IngressBackend,IngressBackendBuilder>{

    IngressBackendFluent<?> fluent;
    Boolean validationEnabled;

    public IngressBackendBuilder(){
            this(true);
    }
    public IngressBackendBuilder(Boolean validationEnabled){
            this(new IngressBackend(), validationEnabled);
    }
    public IngressBackendBuilder(IngressBackendFluent<?> fluent){
            this(fluent, true);
    }
    public IngressBackendBuilder(IngressBackendFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new IngressBackend(), validationEnabled);
    }
    public IngressBackendBuilder(IngressBackendFluent<?> fluent,IngressBackend instance){
            this(fluent, instance, true);
    }
    public IngressBackendBuilder(IngressBackendFluent<?> fluent,IngressBackend instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withServiceName(instance.getServiceName()); 
            fluent.withServicePort(instance.getServicePort()); 
            this.validationEnabled = validationEnabled; 
    }
    public IngressBackendBuilder(IngressBackend instance){
            this(instance,true);
    }
    public IngressBackendBuilder(IngressBackend instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withServiceName(instance.getServiceName()); 
            this.withServicePort(instance.getServicePort()); 
            this.validationEnabled = validationEnabled; 
    }

    public IngressBackend build(){
            IngressBackend buildable = new IngressBackend(fluent.getServiceName(),fluent.getServicePort());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            IngressBackendBuilder that = (IngressBackendBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
