package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class HorizontalPodAutoscalerStatusBuilder extends HorizontalPodAutoscalerStatusFluentImpl<HorizontalPodAutoscalerStatusBuilder> implements VisitableBuilder<HorizontalPodAutoscalerStatus,HorizontalPodAutoscalerStatusBuilder>{

    HorizontalPodAutoscalerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public HorizontalPodAutoscalerStatusBuilder(){
            this(true);
    }
    public HorizontalPodAutoscalerStatusBuilder(Boolean validationEnabled){
            this(new HorizontalPodAutoscalerStatus(), validationEnabled);
    }
    public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatusFluent<?> fluent){
            this(fluent, true);
    }
    public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HorizontalPodAutoscalerStatus(), validationEnabled);
    }
    public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatusFluent<?> fluent,HorizontalPodAutoscalerStatus instance){
            this(fluent, instance, true);
    }
    public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatusFluent<?> fluent,HorizontalPodAutoscalerStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCurrentCPUUtilizationPercentage(instance.getCurrentCPUUtilizationPercentage()); 
            fluent.withCurrentReplicas(instance.getCurrentReplicas()); 
            fluent.withDesiredReplicas(instance.getDesiredReplicas()); 
            fluent.withLastScaleTime(instance.getLastScaleTime()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            this.validationEnabled = validationEnabled; 
    }
    public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatus instance){
            this(instance,true);
    }
    public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCurrentCPUUtilizationPercentage(instance.getCurrentCPUUtilizationPercentage()); 
            this.withCurrentReplicas(instance.getCurrentReplicas()); 
            this.withDesiredReplicas(instance.getDesiredReplicas()); 
            this.withLastScaleTime(instance.getLastScaleTime()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.validationEnabled = validationEnabled; 
    }

    public HorizontalPodAutoscalerStatus build(){
            HorizontalPodAutoscalerStatus buildable = new HorizontalPodAutoscalerStatus(fluent.getCurrentCPUUtilizationPercentage(),fluent.getCurrentReplicas(),fluent.getDesiredReplicas(),fluent.getLastScaleTime(),fluent.getObservedGeneration());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HorizontalPodAutoscalerStatusBuilder that = (HorizontalPodAutoscalerStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
