package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import java.lang.Object;
import lombok.ToString;

public class DaemonSetSpecFluentImpl<A extends DaemonSetSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DaemonSetSpecFluent<A>{

    private VisitableBuilder<? extends io.fabric8.kubernetes.api.model.extensions.LabelSelector,?> selector;
    private VisitableBuilder<? extends PodTemplateSpec,?> template;

    public DaemonSetSpecFluentImpl(){
    }
    public DaemonSetSpecFluentImpl(DaemonSetSpec instance){
            this.withSelector(instance.getSelector()); 
            this.withTemplate(instance.getTemplate()); 
    }

    public io.fabric8.kubernetes.api.model.extensions.LabelSelector getSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(io.fabric8.kubernetes.api.model.extensions.LabelSelector selector){
            _visitables.remove(this.selector);
            if (selector!=null){ this.selector= new io.fabric8.kubernetes.api.model.extensions.LabelSelectorBuilder(selector); _visitables.add(this.selector);} return (A) this;
    }

    public DaemonSetSpecFluent.ExtensionsSelectorNested<A> withNewExtensionsSelector(){
            return new ExtensionsSelectorNestedImpl();
    }

    public DaemonSetSpecFluent.ExtensionsSelectorNested<A> withNewSelectorLike(io.fabric8.kubernetes.api.model.extensions.LabelSelector item){
            return new ExtensionsSelectorNestedImpl(item);
    }

    public DaemonSetSpecFluent.ExtensionsSelectorNested<A> editExtensionsSelector(){
            return withNewSelectorLike(getSelector());
    }

    public DaemonSetSpecFluent.ExtensionsSelectorNested<A> editOrNewSelector(){
            return withNewSelectorLike(getSelector() != null ? getSelector(): new io.fabric8.kubernetes.api.model.extensions.LabelSelectorBuilder().build());
    }

    public DaemonSetSpecFluent.ExtensionsSelectorNested<A> editOrNewSelectorLike(io.fabric8.kubernetes.api.model.extensions.LabelSelector item){
            return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    public PodTemplateSpec getTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public A withTemplate(PodTemplateSpec template){
            _visitables.remove(this.template);
            if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.add(this.template);} return (A) this;
    }

    public DaemonSetSpecFluent.TemplateNested<A> withNewTemplate(){
            return new TemplateNestedImpl();
    }

    public DaemonSetSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item){
            return new TemplateNestedImpl(item);
    }

    public DaemonSetSpecFluent.TemplateNested<A> editTemplate(){
            return withNewTemplateLike(getTemplate());
    }

    public DaemonSetSpecFluent.TemplateNested<A> editOrNewTemplate(){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): new PodTemplateSpecBuilder().build());
    }

    public DaemonSetSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DaemonSetSpecFluentImpl that = (DaemonSetSpecFluentImpl) o;
            if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
            if (template != null ? !template.equals(that.template) :that.template != null) return false;
            return true;
    }


    public class ExtensionsSelectorNestedImpl<N> extends io.fabric8.kubernetes.api.model.extensions.LabelSelectorFluentImpl<DaemonSetSpecFluent.ExtensionsSelectorNested<N>> implements DaemonSetSpecFluent.ExtensionsSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final io.fabric8.kubernetes.api.model.extensions.LabelSelectorBuilder builder;
    
            ExtensionsSelectorNestedImpl(io.fabric8.kubernetes.api.model.extensions.LabelSelector item){
                    this.builder = new io.fabric8.kubernetes.api.model.extensions.LabelSelectorBuilder(this, item);
            }
            ExtensionsSelectorNestedImpl(){
                    this.builder = new io.fabric8.kubernetes.api.model.extensions.LabelSelectorBuilder(this);
            }
    
    public N and(){
            return (N) DaemonSetSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endExtensionsSelector(){
            return and();
    }

}
    public class TemplateNestedImpl<N> extends PodTemplateSpecFluentImpl<DaemonSetSpecFluent.TemplateNested<N>> implements DaemonSetSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PodTemplateSpecBuilder builder;
    
            TemplateNestedImpl(PodTemplateSpec item){
                    this.builder = new PodTemplateSpecBuilder(this, item);
            }
            TemplateNestedImpl(){
                    this.builder = new PodTemplateSpecBuilder(this);
            }
    
    public N and(){
            return (N) DaemonSetSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate(){
            return and();
    }

}


}
