package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface StatusFluent<A extends StatusFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Integer getCode();
    public A withCode(Integer code);
    public StatusDetails getDetails();
    public A withDetails(StatusDetails details);
    public StatusFluent.DetailsNested<A> withNewDetails();
    public StatusFluent.DetailsNested<A> withNewDetailsLike(StatusDetails item);
    public StatusFluent.DetailsNested<A> editDetails();
    public StatusFluent.DetailsNested<A> editOrNewDetails();
    public StatusFluent.DetailsNested<A> editOrNewDetailsLike(StatusDetails item);
    public String getKind();
    public A withKind(String kind);
    public String getMessage();
    public A withMessage(String message);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public StatusFluent.MetadataNested<A> withNewMetadata();
    public StatusFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public StatusFluent.MetadataNested<A> editMetadata();
    public StatusFluent.MetadataNested<A> editOrNewMetadata();
    public StatusFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
    public A withNewMetadata(String resourceVersion,String selfLink);
    public String getReason();
    public A withReason(String reason);
    public String getStatus();
    public A withStatus(String status);

    public interface DetailsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,StatusDetailsFluent<StatusFluent.DetailsNested<N>>{

        
    public N and();    public N endDetails();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<StatusFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
