package io.fabric8.kubernetes.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class SecretVolumeSourceBuilder extends SecretVolumeSourceFluentImpl<SecretVolumeSourceBuilder> implements VisitableBuilder<SecretVolumeSource,SecretVolumeSourceBuilder>{

    SecretVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public SecretVolumeSourceBuilder(){
            this(true);
    }
    public SecretVolumeSourceBuilder(Boolean validationEnabled){
            this(new SecretVolumeSource(), validationEnabled);
    }
    public SecretVolumeSourceBuilder(SecretVolumeSourceFluent<?> fluent){
            this(fluent, true);
    }
    public SecretVolumeSourceBuilder(SecretVolumeSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SecretVolumeSource(), validationEnabled);
    }
    public SecretVolumeSourceBuilder(SecretVolumeSourceFluent<?> fluent,SecretVolumeSource instance){
            this(fluent, instance, true);
    }
    public SecretVolumeSourceBuilder(SecretVolumeSourceFluent<?> fluent,SecretVolumeSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withItems(instance.getItems()); 
            fluent.withSecretName(instance.getSecretName()); 
            this.validationEnabled = validationEnabled; 
    }
    public SecretVolumeSourceBuilder(SecretVolumeSource instance){
            this(instance,true);
    }
    public SecretVolumeSourceBuilder(SecretVolumeSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withItems(instance.getItems()); 
            this.withSecretName(instance.getSecretName()); 
            this.validationEnabled = validationEnabled; 
    }

    public SecretVolumeSource build(){
            SecretVolumeSource buildable = new SecretVolumeSource(fluent.getItems(),fluent.getSecretName());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SecretVolumeSourceBuilder that = (SecretVolumeSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
