package io.fabric8.kubernetes.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class ResourceRequirementsBuilder extends ResourceRequirementsFluentImpl<ResourceRequirementsBuilder> implements VisitableBuilder<ResourceRequirements,ResourceRequirementsBuilder>{

    ResourceRequirementsFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceRequirementsBuilder(){
            this(true);
    }
    public ResourceRequirementsBuilder(Boolean validationEnabled){
            this(new ResourceRequirements(), validationEnabled);
    }
    public ResourceRequirementsBuilder(ResourceRequirementsFluent<?> fluent){
            this(fluent, true);
    }
    public ResourceRequirementsBuilder(ResourceRequirementsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ResourceRequirements(), validationEnabled);
    }
    public ResourceRequirementsBuilder(ResourceRequirementsFluent<?> fluent,ResourceRequirements instance){
            this(fluent, instance, true);
    }
    public ResourceRequirementsBuilder(ResourceRequirementsFluent<?> fluent,ResourceRequirements instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLimits(instance.getLimits()); 
            fluent.withRequests(instance.getRequests()); 
            this.validationEnabled = validationEnabled; 
    }
    public ResourceRequirementsBuilder(ResourceRequirements instance){
            this(instance,true);
    }
    public ResourceRequirementsBuilder(ResourceRequirements instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLimits(instance.getLimits()); 
            this.withRequests(instance.getRequests()); 
            this.validationEnabled = validationEnabled; 
    }

    public ResourceRequirements build(){
            ResourceRequirements buildable = new ResourceRequirements(fluent.getLimits(),fluent.getRequests());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ResourceRequirementsBuilder that = (ResourceRequirementsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
