package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface ResourceQuotaFluent<A extends ResourceQuotaFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public ResourceQuotaFluent.MetadataNested<A> withNewMetadata();
    public ResourceQuotaFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ResourceQuotaFluent.MetadataNested<A> editMetadata();
    public ResourceQuotaFluent.MetadataNested<A> editOrNewMetadata();
    public ResourceQuotaFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public ResourceQuotaSpec getSpec();
    public A withSpec(ResourceQuotaSpec spec);
    public ResourceQuotaFluent.SpecNested<A> withNewSpec();
    public ResourceQuotaFluent.SpecNested<A> withNewSpecLike(ResourceQuotaSpec item);
    public ResourceQuotaFluent.SpecNested<A> editSpec();
    public ResourceQuotaFluent.SpecNested<A> editOrNewSpec();
    public ResourceQuotaFluent.SpecNested<A> editOrNewSpecLike(ResourceQuotaSpec item);
    public ResourceQuotaStatus getStatus();
    public A withStatus(ResourceQuotaStatus status);
    public ResourceQuotaFluent.StatusNested<A> withNewStatus();
    public ResourceQuotaFluent.StatusNested<A> withNewStatusLike(ResourceQuotaStatus item);
    public ResourceQuotaFluent.StatusNested<A> editStatus();
    public ResourceQuotaFluent.StatusNested<A> editOrNewStatus();
    public ResourceQuotaFluent.StatusNested<A> editOrNewStatusLike(ResourceQuotaStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ResourceQuotaFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ResourceQuotaSpecFluent<ResourceQuotaFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ResourceQuotaStatusFluent<ResourceQuotaFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
