package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class PreferencesFluentImpl<A extends PreferencesFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PreferencesFluent<A>{

    private Boolean colors;
    private List<VisitableBuilder<? extends NamedExtension,?>> extensions =  new ArrayList<VisitableBuilder<? extends NamedExtension,?>>();

    public PreferencesFluentImpl(){
    }
    public PreferencesFluentImpl(Preferences instance){
            this.withColors(instance.getColors()); 
            this.withExtensions(instance.getExtensions()); 
    }

    public Boolean isColors(){
            return this.colors;
    }

    public A withColors(Boolean colors){
            this.colors=colors; return (A) this;
    }

    public A addToExtensions(NamedExtension... items){
            for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.add(builder);this.extensions.add(builder);} return (A)this;
    }

    public A removeFromExtensions(NamedExtension... items){
            for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.remove(builder);this.extensions.remove(builder);} return (A)this;
    }

    public List<NamedExtension> getExtensions(){
            return build(extensions);
    }

    public A withExtensions(List<NamedExtension> extensions){
            _visitables.removeAll(this.extensions);
            this.extensions.clear();
            if (extensions != null) {for (NamedExtension item : extensions){this.addToExtensions(item);}} return (A) this;
    }

    public A withExtensions(NamedExtension... extensions){
            this.extensions.clear(); if (extensions != null) {for (NamedExtension item :extensions){ this.addToExtensions(item);}} return (A) this;
    }

    public PreferencesFluent.ExtensionsNested<A> addNewExtension(){
            return new ExtensionsNestedImpl();
    }

    public PreferencesFluent.ExtensionsNested<A> addNewExtensionLike(NamedExtension item){
            return new ExtensionsNestedImpl(item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PreferencesFluentImpl that = (PreferencesFluentImpl) o;
            if (colors != null ? !colors.equals(that.colors) :that.colors != null) return false;
            if (extensions != null ? !extensions.equals(that.extensions) :that.extensions != null) return false;
            return true;
    }


    public class ExtensionsNestedImpl<N> extends NamedExtensionFluentImpl<PreferencesFluent.ExtensionsNested<N>> implements PreferencesFluent.ExtensionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final NamedExtensionBuilder builder;
    
            ExtensionsNestedImpl(NamedExtension item){
                    this.builder = new NamedExtensionBuilder(this, item);
            }
            ExtensionsNestedImpl(){
                    this.builder = new NamedExtensionBuilder(this);
            }
    
    public N and(){
            return (N) PreferencesFluentImpl.this.addToExtensions(builder.build());
    }
    public N endExtension(){
            return and();
    }

}


}
