package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface PersistentVolumeFluent<A extends PersistentVolumeFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public PersistentVolumeFluent.MetadataNested<A> withNewMetadata();
    public PersistentVolumeFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public PersistentVolumeFluent.MetadataNested<A> editMetadata();
    public PersistentVolumeFluent.MetadataNested<A> editOrNewMetadata();
    public PersistentVolumeFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public PersistentVolumeSpec getSpec();
    public A withSpec(PersistentVolumeSpec spec);
    public PersistentVolumeFluent.SpecNested<A> withNewSpec();
    public PersistentVolumeFluent.SpecNested<A> withNewSpecLike(PersistentVolumeSpec item);
    public PersistentVolumeFluent.SpecNested<A> editSpec();
    public PersistentVolumeFluent.SpecNested<A> editOrNewSpec();
    public PersistentVolumeFluent.SpecNested<A> editOrNewSpecLike(PersistentVolumeSpec item);
    public PersistentVolumeStatus getStatus();
    public A withStatus(PersistentVolumeStatus status);
    public PersistentVolumeFluent.StatusNested<A> withNewStatus();
    public PersistentVolumeFluent.StatusNested<A> withNewStatusLike(PersistentVolumeStatus item);
    public PersistentVolumeFluent.StatusNested<A> editStatus();
    public PersistentVolumeFluent.StatusNested<A> editOrNewStatus();
    public PersistentVolumeFluent.StatusNested<A> editOrNewStatusLike(PersistentVolumeStatus item);
    public A withNewStatus(String message,String phase,String reason);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<PersistentVolumeFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeSpecFluent<PersistentVolumeFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeStatusFluent<PersistentVolumeFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
