package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface NodeFluent<A extends NodeFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public NodeFluent.MetadataNested<A> withNewMetadata();
    public NodeFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public NodeFluent.MetadataNested<A> editMetadata();
    public NodeFluent.MetadataNested<A> editOrNewMetadata();
    public NodeFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public NodeSpec getSpec();
    public A withSpec(NodeSpec spec);
    public NodeFluent.SpecNested<A> withNewSpec();
    public NodeFluent.SpecNested<A> withNewSpecLike(NodeSpec item);
    public NodeFluent.SpecNested<A> editSpec();
    public NodeFluent.SpecNested<A> editOrNewSpec();
    public NodeFluent.SpecNested<A> editOrNewSpecLike(NodeSpec item);
    public A withNewSpec(String externalID,String podCIDR,String providerID,Boolean unschedulable);
    public NodeStatus getStatus();
    public A withStatus(NodeStatus status);
    public NodeFluent.StatusNested<A> withNewStatus();
    public NodeFluent.StatusNested<A> withNewStatusLike(NodeStatus item);
    public NodeFluent.StatusNested<A> editStatus();
    public NodeFluent.StatusNested<A> editOrNewStatus();
    public NodeFluent.StatusNested<A> editOrNewStatusLike(NodeStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<NodeFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NodeSpecFluent<NodeFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NodeStatusFluent<NodeFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
