package io.fabric8.kubernetes.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class LoadBalancerStatusBuilder extends LoadBalancerStatusFluentImpl<LoadBalancerStatusBuilder> implements VisitableBuilder<LoadBalancerStatus,LoadBalancerStatusBuilder>{

    LoadBalancerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public LoadBalancerStatusBuilder(){
            this(true);
    }
    public LoadBalancerStatusBuilder(Boolean validationEnabled){
            this(new LoadBalancerStatus(), validationEnabled);
    }
    public LoadBalancerStatusBuilder(LoadBalancerStatusFluent<?> fluent){
            this(fluent, true);
    }
    public LoadBalancerStatusBuilder(LoadBalancerStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new LoadBalancerStatus(), validationEnabled);
    }
    public LoadBalancerStatusBuilder(LoadBalancerStatusFluent<?> fluent,LoadBalancerStatus instance){
            this(fluent, instance, true);
    }
    public LoadBalancerStatusBuilder(LoadBalancerStatusFluent<?> fluent,LoadBalancerStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withIngress(instance.getIngress()); 
            this.validationEnabled = validationEnabled; 
    }
    public LoadBalancerStatusBuilder(LoadBalancerStatus instance){
            this(instance,true);
    }
    public LoadBalancerStatusBuilder(LoadBalancerStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withIngress(instance.getIngress()); 
            this.validationEnabled = validationEnabled; 
    }

    public LoadBalancerStatus build(){
            LoadBalancerStatus buildable = new LoadBalancerStatus(fluent.getIngress());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LoadBalancerStatusBuilder that = (LoadBalancerStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
