package io.fabric8.kubernetes.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class HandlerBuilder extends HandlerFluentImpl<HandlerBuilder> implements VisitableBuilder<Handler,HandlerBuilder>{

    HandlerFluent<?> fluent;
    Boolean validationEnabled;

    public HandlerBuilder(){
            this(true);
    }
    public HandlerBuilder(Boolean validationEnabled){
            this(new Handler(), validationEnabled);
    }
    public HandlerBuilder(HandlerFluent<?> fluent){
            this(fluent, true);
    }
    public HandlerBuilder(HandlerFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Handler(), validationEnabled);
    }
    public HandlerBuilder(HandlerFluent<?> fluent,Handler instance){
            this(fluent, instance, true);
    }
    public HandlerBuilder(HandlerFluent<?> fluent,Handler instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withExec(instance.getExec()); 
            fluent.withHttpGet(instance.getHttpGet()); 
            fluent.withTcpSocket(instance.getTcpSocket()); 
            this.validationEnabled = validationEnabled; 
    }
    public HandlerBuilder(Handler instance){
            this(instance,true);
    }
    public HandlerBuilder(Handler instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withExec(instance.getExec()); 
            this.withHttpGet(instance.getHttpGet()); 
            this.withTcpSocket(instance.getTcpSocket()); 
            this.validationEnabled = validationEnabled; 
    }

    public Handler build(){
            Handler buildable = new Handler(fluent.getExec(),fluent.getHttpGet(),fluent.getTcpSocket());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HandlerBuilder that = (HandlerBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
