package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface ContainerStateFluent<A extends ContainerStateFluent<A>> extends Fluent<A>{


    public ContainerStateRunning getRunning();
    public A withRunning(ContainerStateRunning running);
    public ContainerStateFluent.RunningNested<A> withNewRunning();
    public ContainerStateFluent.RunningNested<A> withNewRunningLike(ContainerStateRunning item);
    public ContainerStateFluent.RunningNested<A> editRunning();
    public ContainerStateFluent.RunningNested<A> editOrNewRunning();
    public ContainerStateFluent.RunningNested<A> editOrNewRunningLike(ContainerStateRunning item);
    public A withNewRunning(String startedAt);
    public ContainerStateTerminated getTerminated();
    public A withTerminated(ContainerStateTerminated terminated);
    public ContainerStateFluent.TerminatedNested<A> withNewTerminated();
    public ContainerStateFluent.TerminatedNested<A> withNewTerminatedLike(ContainerStateTerminated item);
    public ContainerStateFluent.TerminatedNested<A> editTerminated();
    public ContainerStateFluent.TerminatedNested<A> editOrNewTerminated();
    public ContainerStateFluent.TerminatedNested<A> editOrNewTerminatedLike(ContainerStateTerminated item);
    public ContainerStateWaiting getWaiting();
    public A withWaiting(ContainerStateWaiting waiting);
    public ContainerStateFluent.WaitingNested<A> withNewWaiting();
    public ContainerStateFluent.WaitingNested<A> withNewWaitingLike(ContainerStateWaiting item);
    public ContainerStateFluent.WaitingNested<A> editWaiting();
    public ContainerStateFluent.WaitingNested<A> editOrNewWaiting();
    public ContainerStateFluent.WaitingNested<A> editOrNewWaitingLike(ContainerStateWaiting item);
    public A withNewWaiting(String message,String reason);

    public interface RunningNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerStateRunningFluent<ContainerStateFluent.RunningNested<N>>{

        
    public N and();    public N endRunning();
}
    public interface TerminatedNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerStateTerminatedFluent<ContainerStateFluent.TerminatedNested<N>>{

        
    public N and();    public N endTerminated();
}
    public interface WaitingNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerStateWaitingFluent<ContainerStateFluent.WaitingNested<N>>{

        
    public N and();    public N endWaiting();
}


}
