package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.lang.String;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.validation.constraints.Pattern;
import javax.annotation.Generated;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Integer;
import lombok.ToString;

public interface ContainerFluent<A extends ContainerFluent<A>> extends Fluent<A>{


    public A addToArgs(String... items);
    public A removeFromArgs(String... items);
    public List<String> getArgs();
    public A withArgs(List<String> args);
    public A withArgs(String... args);
    public A addToCommand(String... items);
    public A removeFromCommand(String... items);
    public List<String> getCommand();
    public A withCommand(List<String> command);
    public A withCommand(String... command);
    public A addToEnv(EnvVar... items);
    public A removeFromEnv(EnvVar... items);
    public List<EnvVar> getEnv();
    public A withEnv(List<EnvVar> env);
    public A withEnv(EnvVar... env);
    public ContainerFluent.EnvNested<A> addNewEnv();
    public ContainerFluent.EnvNested<A> addNewEnvLike(EnvVar item);
    public String getImage();
    public A withImage(String image);
    public String getImagePullPolicy();
    public A withImagePullPolicy(String imagePullPolicy);
    public Lifecycle getLifecycle();
    public A withLifecycle(Lifecycle lifecycle);
    public ContainerFluent.LifecycleNested<A> withNewLifecycle();
    public ContainerFluent.LifecycleNested<A> withNewLifecycleLike(Lifecycle item);
    public ContainerFluent.LifecycleNested<A> editLifecycle();
    public ContainerFluent.LifecycleNested<A> editOrNewLifecycle();
    public ContainerFluent.LifecycleNested<A> editOrNewLifecycleLike(Lifecycle item);
    public Probe getLivenessProbe();
    public A withLivenessProbe(Probe livenessProbe);
    public ContainerFluent.LivenessProbeNested<A> withNewLivenessProbe();
    public ContainerFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item);
    public ContainerFluent.LivenessProbeNested<A> editLivenessProbe();
    public ContainerFluent.LivenessProbeNested<A> editOrNewLivenessProbe();
    public ContainerFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item);
    public String getName();
    public A withName(String name);
    public A addToPorts(ContainerPort... items);
    public A removeFromPorts(ContainerPort... items);
    public List<ContainerPort> getPorts();
    public A withPorts(List<ContainerPort> ports);
    public A withPorts(ContainerPort... ports);
    public ContainerFluent.PortsNested<A> addNewPort();
    public ContainerFluent.PortsNested<A> addNewPortLike(ContainerPort item);
    public A addNewPort(Integer containerPort,String hostIP,Integer hostPort,String name,String protocol);
    public Probe getReadinessProbe();
    public A withReadinessProbe(Probe readinessProbe);
    public ContainerFluent.ReadinessProbeNested<A> withNewReadinessProbe();
    public ContainerFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item);
    public ContainerFluent.ReadinessProbeNested<A> editReadinessProbe();
    public ContainerFluent.ReadinessProbeNested<A> editOrNewReadinessProbe();
    public ContainerFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item);
    public ResourceRequirements getResources();
    public A withResources(ResourceRequirements resources);
    public ContainerFluent.ResourcesNested<A> withNewResources();
    public ContainerFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item);
    public ContainerFluent.ResourcesNested<A> editResources();
    public ContainerFluent.ResourcesNested<A> editOrNewResources();
    public ContainerFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item);
    public SecurityContext getSecurityContext();
    public A withSecurityContext(SecurityContext securityContext);
    public ContainerFluent.SecurityContextNested<A> withNewSecurityContext();
    public ContainerFluent.SecurityContextNested<A> withNewSecurityContextLike(SecurityContext item);
    public ContainerFluent.SecurityContextNested<A> editSecurityContext();
    public ContainerFluent.SecurityContextNested<A> editOrNewSecurityContext();
    public ContainerFluent.SecurityContextNested<A> editOrNewSecurityContextLike(SecurityContext item);
    public Boolean isStdin();
    public A withStdin(Boolean stdin);
    public Boolean isStdinOnce();
    public A withStdinOnce(Boolean stdinOnce);
    public String getTerminationMessagePath();
    public A withTerminationMessagePath(String terminationMessagePath);
    public Boolean isTty();
    public A withTty(Boolean tty);
    public A addToVolumeMounts(VolumeMount... items);
    public A removeFromVolumeMounts(VolumeMount... items);
    public List<VolumeMount> getVolumeMounts();
    public A withVolumeMounts(List<VolumeMount> volumeMounts);
    public A withVolumeMounts(VolumeMount... volumeMounts);
    public ContainerFluent.VolumeMountsNested<A> addNewVolumeMount();
    public ContainerFluent.VolumeMountsNested<A> addNewVolumeMountLike(VolumeMount item);
    public A addNewVolumeMount(String mountPath,String name,Boolean readOnly,String subPath);
    public String getWorkingDir();
    public A withWorkingDir(String workingDir);

    public interface EnvNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EnvVarFluent<ContainerFluent.EnvNested<N>>{

        
    public N and();    public N endEnv();
}
    public interface LifecycleNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LifecycleFluent<ContainerFluent.LifecycleNested<N>>{

        
    public N and();    public N endLifecycle();
}
    public interface LivenessProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProbeFluent<ContainerFluent.LivenessProbeNested<N>>{

        
    public N and();    public N endLivenessProbe();
}
    public interface PortsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerPortFluent<ContainerFluent.PortsNested<N>>{

        
    public N and();    public N endPort();
}
    public interface ReadinessProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProbeFluent<ContainerFluent.ReadinessProbeNested<N>>{

        
    public N and();    public N endReadinessProbe();
}
    public interface ResourcesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ResourceRequirementsFluent<ContainerFluent.ResourcesNested<N>>{

        
    public N and();    public N endResources();
}
    public interface SecurityContextNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SecurityContextFluent<ContainerFluent.SecurityContextNested<N>>{

        
    public N and();    public N endSecurityContext();
}
    public interface VolumeMountsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,VolumeMountFluent<ContainerFluent.VolumeMountsNested<N>>{

        
    public N and();    public N endVolumeMount();
}


}
