package io.fabric8.kubernetes.api.model;

import javax.validation.Validation;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;
import javax.validation.Validator;

public class ClusterBuilder extends ClusterFluentImpl<ClusterBuilder> implements VisitableBuilder<Cluster,ClusterBuilder>{

    ClusterFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterBuilder(){
            this(true);
    }
    public ClusterBuilder(Boolean validationEnabled){
            this(new Cluster(), validationEnabled);
    }
    public ClusterBuilder(ClusterFluent<?> fluent){
            this(fluent, true);
    }
    public ClusterBuilder(ClusterFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Cluster(), validationEnabled);
    }
    public ClusterBuilder(ClusterFluent<?> fluent,Cluster instance){
            this(fluent, instance, true);
    }
    public ClusterBuilder(ClusterFluent<?> fluent,Cluster instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withCertificateAuthority(instance.getCertificateAuthority()); 
            fluent.withCertificateAuthorityData(instance.getCertificateAuthorityData()); 
            fluent.withExtensions(instance.getExtensions()); 
            fluent.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify()); 
            fluent.withServer(instance.getServer()); 
            this.validationEnabled = validationEnabled; 
    }
    public ClusterBuilder(Cluster instance){
            this(instance,true);
    }
    public ClusterBuilder(Cluster instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withCertificateAuthority(instance.getCertificateAuthority()); 
            this.withCertificateAuthorityData(instance.getCertificateAuthorityData()); 
            this.withExtensions(instance.getExtensions()); 
            this.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify()); 
            this.withServer(instance.getServer()); 
            this.validationEnabled = validationEnabled; 
    }

    public Cluster build(){
            Cluster buildable = new Cluster(fluent.getApiVersion(),fluent.getCertificateAuthority(),fluent.getCertificateAuthorityData(),fluent.getExtensions(),fluent.isInsecureSkipTlsVerify(),fluent.getServer());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ClusterBuilder that = (ClusterBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
