package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.String;
import java.util.LinkedHashMap;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.ToString;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

public class AuthProviderConfigFluentImpl<A extends AuthProviderConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements AuthProviderConfigFluent<A>{

    private Map<String,String> config = new LinkedHashMap<String,String>();
    private String name;

    public AuthProviderConfigFluentImpl(){
    }
    public AuthProviderConfigFluentImpl(AuthProviderConfig instance){
            this.withConfig(instance.getConfig()); 
            this.withName(instance.getName()); 
    }

    public A addToConfig(String key,String value){
            if(key != null && value != null) {this.config.put(key, value);} return (A)this;
    }

    public A addToConfig(Map<String,String> map){
            if(map != null) { this.config.putAll(map);} return (A)this;
    }

    public A removeFromConfig(String key){
            if(key != null) {this.config.remove(key);} return (A)this;
    }

    public A removeFromConfig(Map<String,String> map){
            if(map != null) { for(Object key : map.keySet()) {this.config.remove(key);}} return (A)this;
    }

    public Map<String,String> getConfig(){
            return this.config;
    }

    public A withConfig(Map<String,String> config){
            this.config.clear();
            if (config != null) {this.config.putAll(config);} return (A) this;
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AuthProviderConfigFluentImpl that = (AuthProviderConfigFluentImpl) o;
            if (config != null ? !config.equals(that.config) :that.config != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            return true;
    }




}
