package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface AuthInfoFluent<A extends AuthInfoFluent<A>> extends Fluent<A>{


    public String getAs();
    public A withAs(String as);
    public AuthProviderConfig getAuthProvider();
    public A withAuthProvider(AuthProviderConfig authProvider);
    public AuthInfoFluent.AuthProviderNested<A> withNewAuthProvider();
    public AuthInfoFluent.AuthProviderNested<A> withNewAuthProviderLike(AuthProviderConfig item);
    public AuthInfoFluent.AuthProviderNested<A> editAuthProvider();
    public AuthInfoFluent.AuthProviderNested<A> editOrNewAuthProvider();
    public AuthInfoFluent.AuthProviderNested<A> editOrNewAuthProviderLike(AuthProviderConfig item);
    public String getClientCertificate();
    public A withClientCertificate(String clientCertificate);
    public String getClientCertificateData();
    public A withClientCertificateData(String clientCertificateData);
    public String getClientKey();
    public A withClientKey(String clientKey);
    public String getClientKeyData();
    public A withClientKeyData(String clientKeyData);
    public A addToExtensions(NamedExtension... items);
    public A removeFromExtensions(NamedExtension... items);
    public List<NamedExtension> getExtensions();
    public A withExtensions(List<NamedExtension> extensions);
    public A withExtensions(NamedExtension... extensions);
    public AuthInfoFluent.ExtensionsNested<A> addNewExtension();
    public AuthInfoFluent.ExtensionsNested<A> addNewExtensionLike(NamedExtension item);
    public String getPassword();
    public A withPassword(String password);
    public String getToken();
    public A withToken(String token);
    public String getUsername();
    public A withUsername(String username);

    public interface AuthProviderNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AuthProviderConfigFluent<AuthInfoFluent.AuthProviderNested<N>>{

        
    public N and();    public N endAuthProvider();
}
    public interface ExtensionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamedExtensionFluent<AuthInfoFluent.ExtensionsNested<N>>{

        
    public N and();    public N endExtension();
}


}
