/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableReplicationControllerStatus;
import io.fabric8.kubernetes.api.model.ReplicationControllerStatus;
import io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ReplicationControllerStatusBuilder
extends ReplicationControllerStatusFluent<ReplicationControllerStatusBuilder>
implements VisitableBuilder<ReplicationControllerStatus, ReplicationControllerStatusBuilder> {
    ReplicationControllerStatusFluent<?> fluent;

    public ReplicationControllerStatusBuilder() {
        this(new ReplicationControllerStatus());
    }

    public ReplicationControllerStatusBuilder(ReplicationControllerStatusFluent<?> fluent) {
        this(fluent, new ReplicationControllerStatus());
    }

    public ReplicationControllerStatusBuilder(ReplicationControllerStatusFluent<?> fluent, ReplicationControllerStatus instance) {
        this.fluent = fluent;
        fluent.withObservedGeneration(instance.getObservedGeneration());
        fluent.withReplicas(instance.getReplicas());
    }

    public ReplicationControllerStatusBuilder(ReplicationControllerStatus instance) {
        this.fluent = this;
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withReplicas(instance.getReplicas());
    }

    @Override
    public EditableReplicationControllerStatus build() {
        EditableReplicationControllerStatus buildable = new EditableReplicationControllerStatus(this.fluent.getObservedGeneration(), this.fluent.getReplicas());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

