package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public class BuildOutputFluent<T extends BuildOutputFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     LocalObjectReference pushSecret;     VisitableBuilder<ObjectReference, ?> to;     Map<String, Object> additionalProperties = new HashMap();

    public LocalObjectReference getPushSecret(){
    return this.pushSecret;
    }
    public T withPushSecret( LocalObjectReference pushSecret){
    this.pushSecret=pushSecret; return (T) this;
    }
    public ObjectReference getTo(){
    return this.to!=null?this.to.build():null;
    }
    public T withTo( ObjectReference to){
    if (to!=null){ this.to= new ObjectReferenceBuilder(to); _visitables.add(this.to);} return (T) this;
    }
    public ToNested<T> withNewTo(){
    return new ToNested<T>();
    }
    public ToNested<T> withNewToLike( ObjectReference item){
    return new ToNested<T>(item);
    }
    public ToNested<T> editTo(){
    return withNewToLike(getTo());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class ToNested<N> extends ObjectReferenceFluent<ToNested<N>> implements Nested<N>{

        private final ObjectReferenceBuilder builder;
    
             ToNested (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             ToNested ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N endTo(){
            return and();
        }
            public N and(){
            return (N) BuildOutputFluent.this.withTo(builder.build());
        }
    
}


}
