package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.ResourceQuotaBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.EndpointsBuilder;
import io.fabric8.kubernetes.api.model.SecurityContextConstraints;
import io.fabric8.kubernetes.api.model.EventBuilder;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.PersistentVolumeFluent;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.NodeBuilder;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceQuotaFluent;
import io.fabric8.kubernetes.api.model.SecurityContextConstraintsFluent;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.SecurityContextConstraintsBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.EndpointsFluent;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.NodeFluent;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.EventFluent;

public class TemplateFluent<T extends TemplateFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     Template.ApiVersion apiVersion;     String kind;     Map<String, String> labels = new HashMap();     VisitableBuilder<ObjectMeta, ?> metadata;     List<HasMetadata> objects = new ArrayList();     List<VisitableBuilder<Build, ?>> buildObjects = new ArrayList();     List<VisitableBuilder<BuildConfig, ?>> buildConfigObjects = new ArrayList();     List<VisitableBuilder<BuildRequest, ?>> buildRequestObjects = new ArrayList();     List<VisitableBuilder<DeploymentConfig, ?>> deploymentConfigObjects = new ArrayList();     List<VisitableBuilder<Image, ?>> imageObjects = new ArrayList();     List<VisitableBuilder<ImageStream, ?>> imageStreamObjects = new ArrayList();     List<VisitableBuilder<OAuthAccessToken, ?>> oAuthAccessTokenObjects = new ArrayList();     List<VisitableBuilder<OAuthAuthorizeToken, ?>> oAuthAuthorizeTokenObjects = new ArrayList();     List<VisitableBuilder<OAuthClient, ?>> oAuthClientObjects = new ArrayList();     List<VisitableBuilder<OAuthClientAuthorization, ?>> oAuthClientAuthorizationObjects = new ArrayList();     List<VisitableBuilder<Route, ?>> routeObjects = new ArrayList();     List<VisitableBuilder<Template, ?>> templateObjects = new ArrayList();     List<VisitableBuilder<Endpoints, ?>> endpointsObjects = new ArrayList();     List<VisitableBuilder<Event, ?>> eventObjects = new ArrayList();     List<VisitableBuilder<Namespace, ?>> namespaceObjects = new ArrayList();     List<VisitableBuilder<Node, ?>> nodeObjects = new ArrayList();     List<VisitableBuilder<PersistentVolume, ?>> persistentVolumeObjects = new ArrayList();     List<VisitableBuilder<PersistentVolumeClaim, ?>> persistentVolumeClaimObjects = new ArrayList();     List<VisitableBuilder<Pod, ?>> podObjects = new ArrayList();     List<VisitableBuilder<ReplicationController, ?>> replicationControllerObjects = new ArrayList();     List<VisitableBuilder<ResourceQuota, ?>> resourceQuotaObjects = new ArrayList();     List<VisitableBuilder<Secret, ?>> secretObjects = new ArrayList();     List<VisitableBuilder<SecurityContextConstraints, ?>> securityContextConstraintsObjects = new ArrayList();     List<VisitableBuilder<Service, ?>> serviceObjects = new ArrayList();     List<VisitableBuilder<ServiceAccount, ?>> serviceAccountObjects = new ArrayList();     List<VisitableBuilder<Parameter, ?>> parameters = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();

    public Template.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( Template.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public T addToLabels( String key,  String value){
    if(key != null && value != null) {this.labels.put(key, value);} return (T)this;
    }
    public Map<String, String> getLabels(){
    return this.labels;
    }
    public T withLabels( Map<String, String> labels){
    this.labels.clear();if (labels != null) {this.labels.putAll(labels);} return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNested<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNested<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public T addToObjects( HasMetadata ...items){
    for (HasMetadata item : items) {if (item instanceof Build){addToBuildObjects((Build)item);}
 else if (item instanceof BuildConfig){addToBuildConfigObjects((BuildConfig)item);}
 else if (item instanceof BuildRequest){addToBuildRequestObjects((BuildRequest)item);}
 else if (item instanceof DeploymentConfig){addToDeploymentConfigObjects((DeploymentConfig)item);}
 else if (item instanceof Image){addToImageObjects((Image)item);}
 else if (item instanceof ImageStream){addToImageStreamObjects((ImageStream)item);}
 else if (item instanceof OAuthAccessToken){addToOAuthAccessTokenObjects((OAuthAccessToken)item);}
 else if (item instanceof OAuthAuthorizeToken){addToOAuthAuthorizeTokenObjects((OAuthAuthorizeToken)item);}
 else if (item instanceof OAuthClient){addToOAuthClientObjects((OAuthClient)item);}
 else if (item instanceof OAuthClientAuthorization){addToOAuthClientAuthorizationObjects((OAuthClientAuthorization)item);}
 else if (item instanceof Route){addToRouteObjects((Route)item);}
 else if (item instanceof Template){addToTemplateObjects((Template)item);}
 else if (item instanceof Endpoints){addToEndpointsObjects((Endpoints)item);}
 else if (item instanceof Event){addToEventObjects((Event)item);}
 else if (item instanceof Namespace){addToNamespaceObjects((Namespace)item);}
 else if (item instanceof Node){addToNodeObjects((Node)item);}
 else if (item instanceof PersistentVolume){addToPersistentVolumeObjects((PersistentVolume)item);}
 else if (item instanceof PersistentVolumeClaim){addToPersistentVolumeClaimObjects((PersistentVolumeClaim)item);}
 else if (item instanceof Pod){addToPodObjects((Pod)item);}
 else if (item instanceof ReplicationController){addToReplicationControllerObjects((ReplicationController)item);}
 else if (item instanceof ResourceQuota){addToResourceQuotaObjects((ResourceQuota)item);}
 else if (item instanceof Secret){addToSecretObjects((Secret)item);}
 else if (item instanceof SecurityContextConstraints){addToSecurityContextConstraintsObjects((SecurityContextConstraints)item);}
 else if (item instanceof Service){addToServiceObjects((Service)item);}
 else if (item instanceof ServiceAccount){addToServiceAccountObjects((ServiceAccount)item);}
} return (T)this;
    }
    public List<HasMetadata> getObjects(){
    return aggregate(build(buildObjects), build(buildConfigObjects), build(buildRequestObjects), build(deploymentConfigObjects), build(imageObjects), build(imageStreamObjects), build(oAuthAccessTokenObjects), build(oAuthAuthorizeTokenObjects), build(oAuthClientObjects), build(oAuthClientAuthorizationObjects), build(routeObjects), build(templateObjects), build(endpointsObjects), build(eventObjects), build(namespaceObjects), build(nodeObjects), build(persistentVolumeObjects), build(persistentVolumeClaimObjects), build(podObjects), build(replicationControllerObjects), build(resourceQuotaObjects), build(secretObjects), build(securityContextConstraintsObjects), build(serviceObjects), build(serviceAccountObjects));
    }
    public T withObjects( List<HasMetadata> objects){
    this.objects.clear();if (objects != null) {for (HasMetadata item : objects){this.addToObjects(item);}} return (T) this;
    }
    public T withObjects( HasMetadata ...objects){
    this.objects.clear(); if (objects != null) {for (HasMetadata item :objects){ this.addToObjects(item);}} return (T) this;
    }
    public T addToBuildObjects( Build ...items){
    for (Build item : items) {BuildBuilder builder = new BuildBuilder(item);_visitables.add(builder);this.buildObjects.add(builder);} return (T)this;
    }
    public BuildObjectsNested<T> addNewBuildObject(){
    return new BuildObjectsNested<T>();
    }
    public BuildObjectsNested<T> addNewBuildObjectLike( Build item){
    return new BuildObjectsNested<T>(item);
    }
    public T addToBuildConfigObjects( BuildConfig ...items){
    for (BuildConfig item : items) {BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.add(builder);this.buildConfigObjects.add(builder);} return (T)this;
    }
    public BuildConfigObjectsNested<T> addNewBuildConfigObject(){
    return new BuildConfigObjectsNested<T>();
    }
    public BuildConfigObjectsNested<T> addNewBuildConfigObjectLike( BuildConfig item){
    return new BuildConfigObjectsNested<T>(item);
    }
    public T addToBuildRequestObjects( BuildRequest ...items){
    for (BuildRequest item : items) {BuildRequestBuilder builder = new BuildRequestBuilder(item);_visitables.add(builder);this.buildRequestObjects.add(builder);} return (T)this;
    }
    public BuildRequestObjectsNested<T> addNewBuildRequestObject(){
    return new BuildRequestObjectsNested<T>();
    }
    public BuildRequestObjectsNested<T> addNewBuildRequestObjectLike( BuildRequest item){
    return new BuildRequestObjectsNested<T>(item);
    }
    public T addToDeploymentConfigObjects( DeploymentConfig ...items){
    for (DeploymentConfig item : items) {DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);_visitables.add(builder);this.deploymentConfigObjects.add(builder);} return (T)this;
    }
    public DeploymentConfigObjectsNested<T> addNewDeploymentConfigObject(){
    return new DeploymentConfigObjectsNested<T>();
    }
    public DeploymentConfigObjectsNested<T> addNewDeploymentConfigObjectLike( DeploymentConfig item){
    return new DeploymentConfigObjectsNested<T>(item);
    }
    public T addToImageObjects( Image ...items){
    for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.add(builder);this.imageObjects.add(builder);} return (T)this;
    }
    public ImageObjectsNested<T> addNewImageObject(){
    return new ImageObjectsNested<T>();
    }
    public ImageObjectsNested<T> addNewImageObjectLike( Image item){
    return new ImageObjectsNested<T>(item);
    }
    public T addToImageStreamObjects( ImageStream ...items){
    for (ImageStream item : items) {ImageStreamBuilder builder = new ImageStreamBuilder(item);_visitables.add(builder);this.imageStreamObjects.add(builder);} return (T)this;
    }
    public ImageStreamObjectsNested<T> addNewImageStreamObject(){
    return new ImageStreamObjectsNested<T>();
    }
    public ImageStreamObjectsNested<T> addNewImageStreamObjectLike( ImageStream item){
    return new ImageStreamObjectsNested<T>(item);
    }
    public T addToOAuthAccessTokenObjects( OAuthAccessToken ...items){
    for (OAuthAccessToken item : items) {OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.add(builder);this.oAuthAccessTokenObjects.add(builder);} return (T)this;
    }
    public OAuthAccessTokenObjectsNested<T> addNewOAuthAccessTokenObject(){
    return new OAuthAccessTokenObjectsNested<T>();
    }
    public OAuthAccessTokenObjectsNested<T> addNewOAuthAccessTokenObjectLike( OAuthAccessToken item){
    return new OAuthAccessTokenObjectsNested<T>(item);
    }
    public T addToOAuthAuthorizeTokenObjects( OAuthAuthorizeToken ...items){
    for (OAuthAuthorizeToken item : items) {OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);_visitables.add(builder);this.oAuthAuthorizeTokenObjects.add(builder);} return (T)this;
    }
    public OAuthAuthorizeTokenObjectsNested<T> addNewOAuthAuthorizeTokenObject(){
    return new OAuthAuthorizeTokenObjectsNested<T>();
    }
    public OAuthAuthorizeTokenObjectsNested<T> addNewOAuthAuthorizeTokenObjectLike( OAuthAuthorizeToken item){
    return new OAuthAuthorizeTokenObjectsNested<T>(item);
    }
    public T addToOAuthClientObjects( OAuthClient ...items){
    for (OAuthClient item : items) {OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.add(builder);this.oAuthClientObjects.add(builder);} return (T)this;
    }
    public OAuthClientObjectsNested<T> addNewOAuthClientObject(){
    return new OAuthClientObjectsNested<T>();
    }
    public OAuthClientObjectsNested<T> addNewOAuthClientObjectLike( OAuthClient item){
    return new OAuthClientObjectsNested<T>(item);
    }
    public T addToOAuthClientAuthorizationObjects( OAuthClientAuthorization ...items){
    for (OAuthClientAuthorization item : items) {OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);_visitables.add(builder);this.oAuthClientAuthorizationObjects.add(builder);} return (T)this;
    }
    public OAuthClientAuthorizationObjectsNested<T> addNewOAuthClientAuthorizationObject(){
    return new OAuthClientAuthorizationObjectsNested<T>();
    }
    public OAuthClientAuthorizationObjectsNested<T> addNewOAuthClientAuthorizationObjectLike( OAuthClientAuthorization item){
    return new OAuthClientAuthorizationObjectsNested<T>(item);
    }
    public T addToRouteObjects( Route ...items){
    for (Route item : items) {RouteBuilder builder = new RouteBuilder(item);_visitables.add(builder);this.routeObjects.add(builder);} return (T)this;
    }
    public RouteObjectsNested<T> addNewRouteObject(){
    return new RouteObjectsNested<T>();
    }
    public RouteObjectsNested<T> addNewRouteObjectLike( Route item){
    return new RouteObjectsNested<T>(item);
    }
    public T addToTemplateObjects( Template ...items){
    for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.add(builder);this.templateObjects.add(builder);} return (T)this;
    }
    public TemplateObjectsNested<T> addNewTemplateObject(){
    return new TemplateObjectsNested<T>();
    }
    public TemplateObjectsNested<T> addNewTemplateObjectLike( Template item){
    return new TemplateObjectsNested<T>(item);
    }
    public T addToEndpointsObjects( Endpoints ...items){
    for (Endpoints item : items) {EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.add(builder);this.endpointsObjects.add(builder);} return (T)this;
    }
    public EndpointsObjectsNested<T> addNewEndpointsObject(){
    return new EndpointsObjectsNested<T>();
    }
    public EndpointsObjectsNested<T> addNewEndpointsObjectLike( Endpoints item){
    return new EndpointsObjectsNested<T>(item);
    }
    public T addToEventObjects( Event ...items){
    for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.add(builder);this.eventObjects.add(builder);} return (T)this;
    }
    public EventObjectsNested<T> addNewEventObject(){
    return new EventObjectsNested<T>();
    }
    public EventObjectsNested<T> addNewEventObjectLike( Event item){
    return new EventObjectsNested<T>(item);
    }
    public T addToNamespaceObjects( Namespace ...items){
    for (Namespace item : items) {NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.add(builder);this.namespaceObjects.add(builder);} return (T)this;
    }
    public NamespaceObjectsNested<T> addNewNamespaceObject(){
    return new NamespaceObjectsNested<T>();
    }
    public NamespaceObjectsNested<T> addNewNamespaceObjectLike( Namespace item){
    return new NamespaceObjectsNested<T>(item);
    }
    public T addToNodeObjects( Node ...items){
    for (Node item : items) {NodeBuilder builder = new NodeBuilder(item);_visitables.add(builder);this.nodeObjects.add(builder);} return (T)this;
    }
    public NodeObjectsNested<T> addNewNodeObject(){
    return new NodeObjectsNested<T>();
    }
    public NodeObjectsNested<T> addNewNodeObjectLike( Node item){
    return new NodeObjectsNested<T>(item);
    }
    public T addToPersistentVolumeObjects( PersistentVolume ...items){
    for (PersistentVolume item : items) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.add(builder);this.persistentVolumeObjects.add(builder);} return (T)this;
    }
    public PersistentVolumeObjectsNested<T> addNewPersistentVolumeObject(){
    return new PersistentVolumeObjectsNested<T>();
    }
    public PersistentVolumeObjectsNested<T> addNewPersistentVolumeObjectLike( PersistentVolume item){
    return new PersistentVolumeObjectsNested<T>(item);
    }
    public T addToPersistentVolumeClaimObjects( PersistentVolumeClaim ...items){
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.add(builder);this.persistentVolumeClaimObjects.add(builder);} return (T)this;
    }
    public PersistentVolumeClaimObjectsNested<T> addNewPersistentVolumeClaimObject(){
    return new PersistentVolumeClaimObjectsNested<T>();
    }
    public PersistentVolumeClaimObjectsNested<T> addNewPersistentVolumeClaimObjectLike( PersistentVolumeClaim item){
    return new PersistentVolumeClaimObjectsNested<T>(item);
    }
    public T addToPodObjects( Pod ...items){
    for (Pod item : items) {PodBuilder builder = new PodBuilder(item);_visitables.add(builder);this.podObjects.add(builder);} return (T)this;
    }
    public PodObjectsNested<T> addNewPodObject(){
    return new PodObjectsNested<T>();
    }
    public PodObjectsNested<T> addNewPodObjectLike( Pod item){
    return new PodObjectsNested<T>(item);
    }
    public T addToReplicationControllerObjects( ReplicationController ...items){
    for (ReplicationController item : items) {ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.add(builder);this.replicationControllerObjects.add(builder);} return (T)this;
    }
    public ReplicationControllerObjectsNested<T> addNewReplicationControllerObject(){
    return new ReplicationControllerObjectsNested<T>();
    }
    public ReplicationControllerObjectsNested<T> addNewReplicationControllerObjectLike( ReplicationController item){
    return new ReplicationControllerObjectsNested<T>(item);
    }
    public T addToResourceQuotaObjects( ResourceQuota ...items){
    for (ResourceQuota item : items) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.add(builder);this.resourceQuotaObjects.add(builder);} return (T)this;
    }
    public ResourceQuotaObjectsNested<T> addNewResourceQuotaObject(){
    return new ResourceQuotaObjectsNested<T>();
    }
    public ResourceQuotaObjectsNested<T> addNewResourceQuotaObjectLike( ResourceQuota item){
    return new ResourceQuotaObjectsNested<T>(item);
    }
    public T addToSecretObjects( Secret ...items){
    for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.add(builder);this.secretObjects.add(builder);} return (T)this;
    }
    public SecretObjectsNested<T> addNewSecretObject(){
    return new SecretObjectsNested<T>();
    }
    public SecretObjectsNested<T> addNewSecretObjectLike( Secret item){
    return new SecretObjectsNested<T>(item);
    }
    public T addToSecurityContextConstraintsObjects( SecurityContextConstraints ...items){
    for (SecurityContextConstraints item : items) {SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);_visitables.add(builder);this.securityContextConstraintsObjects.add(builder);} return (T)this;
    }
    public SecurityContextConstraintsObjectsNested<T> addNewSecurityContextConstraintsObject(){
    return new SecurityContextConstraintsObjectsNested<T>();
    }
    public SecurityContextConstraintsObjectsNested<T> addNewSecurityContextConstraintsObjectLike( SecurityContextConstraints item){
    return new SecurityContextConstraintsObjectsNested<T>(item);
    }
    public T addToServiceObjects( Service ...items){
    for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.add(builder);this.serviceObjects.add(builder);} return (T)this;
    }
    public ServiceObjectsNested<T> addNewServiceObject(){
    return new ServiceObjectsNested<T>();
    }
    public ServiceObjectsNested<T> addNewServiceObjectLike( Service item){
    return new ServiceObjectsNested<T>(item);
    }
    public T addToServiceAccountObjects( ServiceAccount ...items){
    for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.add(builder);this.serviceAccountObjects.add(builder);} return (T)this;
    }
    public ServiceAccountObjectsNested<T> addNewServiceAccountObject(){
    return new ServiceAccountObjectsNested<T>();
    }
    public ServiceAccountObjectsNested<T> addNewServiceAccountObjectLike( ServiceAccount item){
    return new ServiceAccountObjectsNested<T>(item);
    }
    public T addToParameters( Parameter ...items){
    for (Parameter item : items) {ParameterBuilder builder = new ParameterBuilder(item);_visitables.add(builder);this.parameters.add(builder);} return (T)this;
    }
    public List<Parameter> getParameters(){
    return build(parameters);
    }
    public T withParameters( List<Parameter> parameters){
    this.parameters.clear();if (parameters != null) {for (Parameter item : parameters){this.addToParameters(item);}} return (T) this;
    }
    public T withParameters( Parameter ...parameters){
    this.parameters.clear(); if (parameters != null) {for (Parameter item :parameters){ this.addToParameters(item);}} return (T) this;
    }
    public ParametersNested<T> addNewParameter(){
    return new ParametersNested<T>();
    }
    public ParametersNested<T> addNewParameterLike( Parameter item){
    return new ParametersNested<T>(item);
    }
    public T addNewParameter( String description,  String from,  String generate,  String name,  String value){
    return addToParameters(new Parameter(description, from, generate, name, value));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNested (){
        this.builder = new ObjectMetaBuilder(this);
        }
             MetadataNested ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
    
            public N endMetadata(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.withMetadata(builder.build());
        }
    
}
    public class BuildObjectsNested<N> extends BuildFluent<BuildObjectsNested<N>> implements Nested<N>{

        private final BuildBuilder builder;
    
             BuildObjectsNested (){
        this.builder = new BuildBuilder(this);
        }
             BuildObjectsNested ( Build item){
        this.builder = new BuildBuilder(this, item);
        }
    
            public N endBuildObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToBuildObjects(builder.build());
        }
    
}
    public class BuildConfigObjectsNested<N> extends BuildConfigFluent<BuildConfigObjectsNested<N>> implements Nested<N>{

        private final BuildConfigBuilder builder;
    
             BuildConfigObjectsNested ( BuildConfig item){
        this.builder = new BuildConfigBuilder(this, item);
        }
             BuildConfigObjectsNested (){
        this.builder = new BuildConfigBuilder(this);
        }
    
            public N endBuildConfigObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToBuildConfigObjects(builder.build());
        }
    
}
    public class BuildRequestObjectsNested<N> extends BuildRequestFluent<BuildRequestObjectsNested<N>> implements Nested<N>{

        private final BuildRequestBuilder builder;
    
             BuildRequestObjectsNested (){
        this.builder = new BuildRequestBuilder(this);
        }
             BuildRequestObjectsNested ( BuildRequest item){
        this.builder = new BuildRequestBuilder(this, item);
        }
    
            public N endBuildRequestObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToBuildRequestObjects(builder.build());
        }
    
}
    public class DeploymentConfigObjectsNested<N> extends DeploymentConfigFluent<DeploymentConfigObjectsNested<N>> implements Nested<N>{

        private final DeploymentConfigBuilder builder;
    
             DeploymentConfigObjectsNested (){
        this.builder = new DeploymentConfigBuilder(this);
        }
             DeploymentConfigObjectsNested ( DeploymentConfig item){
        this.builder = new DeploymentConfigBuilder(this, item);
        }
    
            public N endDeploymentConfigObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToDeploymentConfigObjects(builder.build());
        }
    
}
    public class ImageObjectsNested<N> extends ImageFluent<ImageObjectsNested<N>> implements Nested<N>{

        private final ImageBuilder builder;
    
             ImageObjectsNested (){
        this.builder = new ImageBuilder(this);
        }
             ImageObjectsNested ( Image item){
        this.builder = new ImageBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluent.this.addToImageObjects(builder.build());
        }
            public N endImageObject(){
            return and();
        }
    
}
    public class ImageStreamObjectsNested<N> extends ImageStreamFluent<ImageStreamObjectsNested<N>> implements Nested<N>{

        private final ImageStreamBuilder builder;
    
             ImageStreamObjectsNested (){
        this.builder = new ImageStreamBuilder(this);
        }
             ImageStreamObjectsNested ( ImageStream item){
        this.builder = new ImageStreamBuilder(this, item);
        }
    
            public N endImageStreamObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToImageStreamObjects(builder.build());
        }
    
}
    public class OAuthAccessTokenObjectsNested<N> extends OAuthAccessTokenFluent<OAuthAccessTokenObjectsNested<N>> implements Nested<N>{

        private final OAuthAccessTokenBuilder builder;
    
             OAuthAccessTokenObjectsNested (){
        this.builder = new OAuthAccessTokenBuilder(this);
        }
             OAuthAccessTokenObjectsNested ( OAuthAccessToken item){
        this.builder = new OAuthAccessTokenBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluent.this.addToOAuthAccessTokenObjects(builder.build());
        }
            public N endOAuthAccessTokenObject(){
            return and();
        }
    
}
    public class OAuthAuthorizeTokenObjectsNested<N> extends OAuthAuthorizeTokenFluent<OAuthAuthorizeTokenObjectsNested<N>> implements Nested<N>{

        private final OAuthAuthorizeTokenBuilder builder;
    
             OAuthAuthorizeTokenObjectsNested (){
        this.builder = new OAuthAuthorizeTokenBuilder(this);
        }
             OAuthAuthorizeTokenObjectsNested ( OAuthAuthorizeToken item){
        this.builder = new OAuthAuthorizeTokenBuilder(this, item);
        }
    
            public N endOAuthAuthorizeTokenObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToOAuthAuthorizeTokenObjects(builder.build());
        }
    
}
    public class OAuthClientObjectsNested<N> extends OAuthClientFluent<OAuthClientObjectsNested<N>> implements Nested<N>{

        private final OAuthClientBuilder builder;
    
             OAuthClientObjectsNested (){
        this.builder = new OAuthClientBuilder(this);
        }
             OAuthClientObjectsNested ( OAuthClient item){
        this.builder = new OAuthClientBuilder(this, item);
        }
    
            public N endOAuthClientObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToOAuthClientObjects(builder.build());
        }
    
}
    public class OAuthClientAuthorizationObjectsNested<N> extends OAuthClientAuthorizationFluent<OAuthClientAuthorizationObjectsNested<N>> implements Nested<N>{

        private final OAuthClientAuthorizationBuilder builder;
    
             OAuthClientAuthorizationObjectsNested ( OAuthClientAuthorization item){
        this.builder = new OAuthClientAuthorizationBuilder(this, item);
        }
             OAuthClientAuthorizationObjectsNested (){
        this.builder = new OAuthClientAuthorizationBuilder(this);
        }
    
            public N endOAuthClientAuthorizationObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToOAuthClientAuthorizationObjects(builder.build());
        }
    
}
    public class RouteObjectsNested<N> extends RouteFluent<RouteObjectsNested<N>> implements Nested<N>{

        private final RouteBuilder builder;
    
             RouteObjectsNested (){
        this.builder = new RouteBuilder(this);
        }
             RouteObjectsNested ( Route item){
        this.builder = new RouteBuilder(this, item);
        }
    
            public N endRouteObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToRouteObjects(builder.build());
        }
    
}
    public class TemplateObjectsNested<N> extends TemplateFluent<TemplateObjectsNested<N>> implements Nested<N>{

        private final TemplateBuilder builder;
    
             TemplateObjectsNested (){
        this.builder = new TemplateBuilder(this);
        }
             TemplateObjectsNested ( Template item){
        this.builder = new TemplateBuilder(this, item);
        }
    
            public N endTemplateObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToTemplateObjects(builder.build());
        }
    
}
    public class EndpointsObjectsNested<N> extends EndpointsFluent<EndpointsObjectsNested<N>> implements Nested<N>{

        private final EndpointsBuilder builder;
    
             EndpointsObjectsNested (){
        this.builder = new EndpointsBuilder(this);
        }
             EndpointsObjectsNested ( Endpoints item){
        this.builder = new EndpointsBuilder(this, item);
        }
    
            public N endEndpointsObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToEndpointsObjects(builder.build());
        }
    
}
    public class EventObjectsNested<N> extends EventFluent<EventObjectsNested<N>> implements Nested<N>{

        private final EventBuilder builder;
    
             EventObjectsNested (){
        this.builder = new EventBuilder(this);
        }
             EventObjectsNested ( Event item){
        this.builder = new EventBuilder(this, item);
        }
    
            public N endEventObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToEventObjects(builder.build());
        }
    
}
    public class NamespaceObjectsNested<N> extends NamespaceFluent<NamespaceObjectsNested<N>> implements Nested<N>{

        private final NamespaceBuilder builder;
    
             NamespaceObjectsNested (){
        this.builder = new NamespaceBuilder(this);
        }
             NamespaceObjectsNested ( Namespace item){
        this.builder = new NamespaceBuilder(this, item);
        }
    
            public N endNamespaceObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToNamespaceObjects(builder.build());
        }
    
}
    public class NodeObjectsNested<N> extends NodeFluent<NodeObjectsNested<N>> implements Nested<N>{

        private final NodeBuilder builder;
    
             NodeObjectsNested (){
        this.builder = new NodeBuilder(this);
        }
             NodeObjectsNested ( Node item){
        this.builder = new NodeBuilder(this, item);
        }
    
            public N endNodeObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToNodeObjects(builder.build());
        }
    
}
    public class PersistentVolumeObjectsNested<N> extends PersistentVolumeFluent<PersistentVolumeObjectsNested<N>> implements Nested<N>{

        private final PersistentVolumeBuilder builder;
    
             PersistentVolumeObjectsNested (){
        this.builder = new PersistentVolumeBuilder(this);
        }
             PersistentVolumeObjectsNested ( PersistentVolume item){
        this.builder = new PersistentVolumeBuilder(this, item);
        }
    
            public N endPersistentVolumeObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToPersistentVolumeObjects(builder.build());
        }
    
}
    public class PersistentVolumeClaimObjectsNested<N> extends PersistentVolumeClaimFluent<PersistentVolumeClaimObjectsNested<N>> implements Nested<N>{

        private final PersistentVolumeClaimBuilder builder;
    
             PersistentVolumeClaimObjectsNested (){
        this.builder = new PersistentVolumeClaimBuilder(this);
        }
             PersistentVolumeClaimObjectsNested ( PersistentVolumeClaim item){
        this.builder = new PersistentVolumeClaimBuilder(this, item);
        }
    
            public N endPersistentVolumeClaimObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToPersistentVolumeClaimObjects(builder.build());
        }
    
}
    public class PodObjectsNested<N> extends PodFluent<PodObjectsNested<N>> implements Nested<N>{

        private final PodBuilder builder;
    
             PodObjectsNested (){
        this.builder = new PodBuilder(this);
        }
             PodObjectsNested ( Pod item){
        this.builder = new PodBuilder(this, item);
        }
    
            public N endPodObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToPodObjects(builder.build());
        }
    
}
    public class ReplicationControllerObjectsNested<N> extends ReplicationControllerFluent<ReplicationControllerObjectsNested<N>> implements Nested<N>{

        private final ReplicationControllerBuilder builder;
    
             ReplicationControllerObjectsNested (){
        this.builder = new ReplicationControllerBuilder(this);
        }
             ReplicationControllerObjectsNested ( ReplicationController item){
        this.builder = new ReplicationControllerBuilder(this, item);
        }
    
            public N endReplicationControllerObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToReplicationControllerObjects(builder.build());
        }
    
}
    public class ResourceQuotaObjectsNested<N> extends ResourceQuotaFluent<ResourceQuotaObjectsNested<N>> implements Nested<N>{

        private final ResourceQuotaBuilder builder;
    
             ResourceQuotaObjectsNested (){
        this.builder = new ResourceQuotaBuilder(this);
        }
             ResourceQuotaObjectsNested ( ResourceQuota item){
        this.builder = new ResourceQuotaBuilder(this, item);
        }
    
            public N endResourceQuotaObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToResourceQuotaObjects(builder.build());
        }
    
}
    public class SecretObjectsNested<N> extends SecretFluent<SecretObjectsNested<N>> implements Nested<N>{

        private final SecretBuilder builder;
    
             SecretObjectsNested (){
        this.builder = new SecretBuilder(this);
        }
             SecretObjectsNested ( Secret item){
        this.builder = new SecretBuilder(this, item);
        }
    
            public N endSecretObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToSecretObjects(builder.build());
        }
    
}
    public class SecurityContextConstraintsObjectsNested<N> extends SecurityContextConstraintsFluent<SecurityContextConstraintsObjectsNested<N>> implements Nested<N>{

        private final SecurityContextConstraintsBuilder builder;
    
             SecurityContextConstraintsObjectsNested (){
        this.builder = new SecurityContextConstraintsBuilder(this);
        }
             SecurityContextConstraintsObjectsNested ( SecurityContextConstraints item){
        this.builder = new SecurityContextConstraintsBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluent.this.addToSecurityContextConstraintsObjects(builder.build());
        }
            public N endSecurityContextConstraintsObject(){
            return and();
        }
    
}
    public class ServiceObjectsNested<N> extends ServiceFluent<ServiceObjectsNested<N>> implements Nested<N>{

        private final ServiceBuilder builder;
    
             ServiceObjectsNested (){
        this.builder = new ServiceBuilder(this);
        }
             ServiceObjectsNested ( Service item){
        this.builder = new ServiceBuilder(this, item);
        }
    
            public N endServiceObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToServiceObjects(builder.build());
        }
    
}
    public class ServiceAccountObjectsNested<N> extends ServiceAccountFluent<ServiceAccountObjectsNested<N>> implements Nested<N>{

        private final ServiceAccountBuilder builder;
    
             ServiceAccountObjectsNested (){
        this.builder = new ServiceAccountBuilder(this);
        }
             ServiceAccountObjectsNested ( ServiceAccount item){
        this.builder = new ServiceAccountBuilder(this, item);
        }
    
            public N endServiceAccountObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToServiceAccountObjects(builder.build());
        }
    
}
    public class ParametersNested<N> extends ParameterFluent<ParametersNested<N>> implements Nested<N>{

        private final ParameterBuilder builder;
    
             ParametersNested (){
        this.builder = new ParameterBuilder(this);
        }
             ParametersNested ( Parameter item){
        this.builder = new ParameterBuilder(this, item);
        }
    
            public N endParameter(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToParameters(builder.build());
        }
    
}


}
