package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public interface RoleListFluent<A extends RoleListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(Role... items);
    public A removeFromItems(Role... items);
    public List<Role> getItems();
    public A withItems(List<Role> items);
    public A withItems(Role... items);
    public RoleListFluent.ItemsNested<A> addNewItem();
    public RoleListFluent.ItemsNested<A> addNewItemLike(Role item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public RoleListFluent.MetadataNested<A> withNewMetadata();
    public RoleListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public RoleListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,RoleFluent<RoleListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<RoleListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
