package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class RecreateDeploymentStrategyParamsBuilder extends RecreateDeploymentStrategyParamsFluentImpl<RecreateDeploymentStrategyParamsBuilder> implements VisitableBuilder<RecreateDeploymentStrategyParams,RecreateDeploymentStrategyParamsBuilder>{

    RecreateDeploymentStrategyParamsFluent<?> fluent;
    Boolean validationEnabled;

    public RecreateDeploymentStrategyParamsBuilder(){
            this(true);
    }
    public RecreateDeploymentStrategyParamsBuilder(Boolean validationEnabled){
            this(new RecreateDeploymentStrategyParams(), validationEnabled);
    }
    public RecreateDeploymentStrategyParamsBuilder(RecreateDeploymentStrategyParamsFluent<?> fluent){
            this(fluent, true);
    }
    public RecreateDeploymentStrategyParamsBuilder(RecreateDeploymentStrategyParamsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RecreateDeploymentStrategyParams(), validationEnabled);
    }
    public RecreateDeploymentStrategyParamsBuilder(RecreateDeploymentStrategyParamsFluent<?> fluent,RecreateDeploymentStrategyParams instance){
            this(fluent, instance, true);
    }
    public RecreateDeploymentStrategyParamsBuilder(RecreateDeploymentStrategyParamsFluent<?> fluent,RecreateDeploymentStrategyParams instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMid(instance.getMid()); 
            fluent.withPost(instance.getPost()); 
            fluent.withPre(instance.getPre()); 
            fluent.withTimeoutSeconds(instance.getTimeoutSeconds()); 
            this.validationEnabled = validationEnabled; 
    }
    public RecreateDeploymentStrategyParamsBuilder(RecreateDeploymentStrategyParams instance){
            this(instance,true);
    }
    public RecreateDeploymentStrategyParamsBuilder(RecreateDeploymentStrategyParams instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMid(instance.getMid()); 
            this.withPost(instance.getPost()); 
            this.withPre(instance.getPre()); 
            this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
            this.validationEnabled = validationEnabled; 
    }

    public RecreateDeploymentStrategyParams build(){
            RecreateDeploymentStrategyParams buildable = new RecreateDeploymentStrategyParams(fluent.getMid(),fluent.getPost(),fluent.getPre(),fluent.getTimeoutSeconds());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RecreateDeploymentStrategyParamsBuilder that = (RecreateDeploymentStrategyParamsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
