package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public interface PolicyBindingListFluent<A extends PolicyBindingListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(PolicyBinding... items);
    public A removeFromItems(PolicyBinding... items);
    public List<PolicyBinding> getItems();
    public A withItems(List<PolicyBinding> items);
    public A withItems(PolicyBinding... items);
    public PolicyBindingListFluent.ItemsNested<A> addNewItem();
    public PolicyBindingListFluent.ItemsNested<A> addNewItemLike(PolicyBinding item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public PolicyBindingListFluent.MetadataNested<A> withNewMetadata();
    public PolicyBindingListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public PolicyBindingListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,PolicyBindingFluent<PolicyBindingListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<PolicyBindingListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
