package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;
import java.lang.Object;

public class NamedTagEventListBuilder extends NamedTagEventListFluentImpl<NamedTagEventListBuilder> implements VisitableBuilder<NamedTagEventList,NamedTagEventListBuilder>{

    NamedTagEventListFluent<?> fluent;
    Boolean validationEnabled;

    public NamedTagEventListBuilder(){
            this(true);
    }
    public NamedTagEventListBuilder(Boolean validationEnabled){
            this(new NamedTagEventList(), validationEnabled);
    }
    public NamedTagEventListBuilder(NamedTagEventListFluent<?> fluent){
            this(fluent, true);
    }
    public NamedTagEventListBuilder(NamedTagEventListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NamedTagEventList(), validationEnabled);
    }
    public NamedTagEventListBuilder(NamedTagEventListFluent<?> fluent,NamedTagEventList instance){
            this(fluent, instance, true);
    }
    public NamedTagEventListBuilder(NamedTagEventListFluent<?> fluent,NamedTagEventList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConditions(instance.getConditions()); 
            fluent.withItems(instance.getItems()); 
            fluent.withTag(instance.getTag()); 
            this.validationEnabled = validationEnabled; 
    }
    public NamedTagEventListBuilder(NamedTagEventList instance){
            this(instance,true);
    }
    public NamedTagEventListBuilder(NamedTagEventList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConditions(instance.getConditions()); 
            this.withItems(instance.getItems()); 
            this.withTag(instance.getTag()); 
            this.validationEnabled = validationEnabled; 
    }

    public NamedTagEventList build(){
            NamedTagEventList buildable = new NamedTagEventList(fluent.getConditions(),fluent.getItems(),fluent.getTag());
            validate(buildable);
            return buildable;
    }

    private <T>void validate(T item){
            if (!validationEnabled) { return; }
            Validator validator = null;
            try {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
            } catch(ValidationException e) {return;}
            Set<ConstraintViolation<T>> violations = validator.validate(item);
            if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
             }
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NamedTagEventListBuilder that = (NamedTagEventListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
