package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class GenericWebHookCauseFluentImpl<A extends GenericWebHookCauseFluent<A>> extends BaseFluent<A> implements GenericWebHookCauseFluent<A>{

    private VisitableBuilder<? extends SourceRevision,?> revision;
    private String secret;

    public GenericWebHookCauseFluentImpl(){
    }
    public GenericWebHookCauseFluentImpl(GenericWebHookCause instance){
            this.withRevision(instance.getRevision()); 
            this.withSecret(instance.getSecret()); 
    }

    public SourceRevision getRevision(){
            return this.revision!=null?this.revision.build():null;
    }

    public A withRevision(SourceRevision revision){
            if (revision!=null){ this.revision= new SourceRevisionBuilder(revision); _visitables.add(this.revision);} return (A) this;
    }

    public GenericWebHookCauseFluent.RevisionNested<A> withNewRevision(){
            return new RevisionNestedImpl();
    }

    public GenericWebHookCauseFluent.RevisionNested<A> withNewRevisionLike(SourceRevision item){
            return new RevisionNestedImpl(item);
    }

    public GenericWebHookCauseFluent.RevisionNested<A> editRevision(){
            return withNewRevisionLike(getRevision());
    }

    public String getSecret(){
            return this.secret;
    }

    public A withSecret(String secret){
            this.secret=secret; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            GenericWebHookCauseFluentImpl that = (GenericWebHookCauseFluentImpl) o;
            if (revision != null ? !revision.equals(that.revision) :that.revision != null) return false;
            if (secret != null ? !secret.equals(that.secret) :that.secret != null) return false;
            return true;
    }


    public class RevisionNestedImpl<N> extends SourceRevisionFluentImpl<GenericWebHookCauseFluent.RevisionNested<N>> implements GenericWebHookCauseFluent.RevisionNested<N>,Nested<N>{

            private final SourceRevisionBuilder builder;
    
            RevisionNestedImpl(){
                    this.builder = new SourceRevisionBuilder(this);
            }
            RevisionNestedImpl(SourceRevision item){
                    this.builder = new SourceRevisionBuilder(this, item);
            }
    
    public N endRevision(){
            return and();
    }
    public N and(){
            return (N) GenericWebHookCauseFluentImpl.this.withRevision(builder.build());
    }

}


}
