package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import javax.validation.Valid;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;

public interface DockerBuildStrategyFluent<A extends DockerBuildStrategyFluent<A>> extends Fluent<A>{


    public String getDockerfilePath();
    public A withDockerfilePath(String dockerfilePath);
    public A addToEnv(EnvVar... items);
    public A removeFromEnv(EnvVar... items);
    public List<EnvVar> getEnv();
    public A withEnv(List<EnvVar> env);
    public A withEnv(EnvVar... env);
    public DockerBuildStrategyFluent.EnvNested<A> addNewEnv();
    public DockerBuildStrategyFluent.EnvNested<A> addNewEnvLike(EnvVar item);
    public Boolean isForcePull();
    public A withForcePull(Boolean forcePull);
    public ObjectReference getFrom();
    public A withFrom(ObjectReference from);
    public DockerBuildStrategyFluent.FromNested<A> withNewFrom();
    public DockerBuildStrategyFluent.FromNested<A> withNewFromLike(ObjectReference item);
    public DockerBuildStrategyFluent.FromNested<A> editFrom();
    public Boolean isNoCache();
    public A withNoCache(Boolean noCache);
    public LocalObjectReference getPullSecret();
    public A withPullSecret(LocalObjectReference pullSecret);
    public DockerBuildStrategyFluent.PullSecretNested<A> withNewPullSecret();
    public DockerBuildStrategyFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item);
    public DockerBuildStrategyFluent.PullSecretNested<A> editPullSecret();
    public A withNewPullSecret(String name);

    public interface EnvNested<N> extends Nested<N>,EnvVarFluent<DockerBuildStrategyFluent.EnvNested<N>>{

        
    public N endEnv();    public N and();
}
    public interface FromNested<N> extends Nested<N>,ObjectReferenceFluent<DockerBuildStrategyFluent.FromNested<N>>{

        
    public N endFrom();    public N and();
}
    public interface PullSecretNested<N> extends Nested<N>,LocalObjectReferenceFluent<DockerBuildStrategyFluent.PullSecretNested<N>>{

        
    public N and();    public N endPullSecret();
}


}
