package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;

public class CustomDeploymentStrategyParamsFluentImpl<A extends CustomDeploymentStrategyParamsFluent<A>> extends BaseFluent<A> implements CustomDeploymentStrategyParamsFluent<A>{

    private List<String> command = new ArrayList<String>();
    private List<VisitableBuilder<? extends EnvVar,?>> environment =  new ArrayList<VisitableBuilder<? extends EnvVar,?>>();
    private String image;

    public CustomDeploymentStrategyParamsFluentImpl(){
    }
    public CustomDeploymentStrategyParamsFluentImpl(CustomDeploymentStrategyParams instance){
            this.withCommand(instance.getCommand()); 
            this.withEnvironment(instance.getEnvironment()); 
            this.withImage(instance.getImage()); 
    }

    public A addToCommand(String... items){
            for (String item : items) {this.command.add(item);} return (A)this;
    }

    public A removeFromCommand(String... items){
            for (String item : items) {this.command.remove(item);} return (A)this;
    }

    public List<String> getCommand(){
            return this.command;
    }

    public A withCommand(List<String> command){
            this.command.clear();
            if (command != null) {for (String item : command){this.addToCommand(item);}} return (A) this;
    }

    public A withCommand(String... command){
            this.command.clear(); if (command != null) {for (String item :command){ this.addToCommand(item);}} return (A) this;
    }

    public A addToEnvironment(EnvVar... items){
            for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.add(builder);this.environment.add(builder);} return (A)this;
    }

    public A removeFromEnvironment(EnvVar... items){
            for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.remove(builder);this.environment.remove(builder);} return (A)this;
    }

    public List<EnvVar> getEnvironment(){
            return build(environment);
    }

    public A withEnvironment(List<EnvVar> environment){
            this.environment.clear();
            if (environment != null) {for (EnvVar item : environment){this.addToEnvironment(item);}} return (A) this;
    }

    public A withEnvironment(EnvVar... environment){
            this.environment.clear(); if (environment != null) {for (EnvVar item :environment){ this.addToEnvironment(item);}} return (A) this;
    }

    public CustomDeploymentStrategyParamsFluent.EnvironmentNested<A> addNewEnvironment(){
            return new EnvironmentNestedImpl();
    }

    public CustomDeploymentStrategyParamsFluent.EnvironmentNested<A> addNewEnvironmentLike(EnvVar item){
            return new EnvironmentNestedImpl(item);
    }

    public String getImage(){
            return this.image;
    }

    public A withImage(String image){
            this.image=image; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CustomDeploymentStrategyParamsFluentImpl that = (CustomDeploymentStrategyParamsFluentImpl) o;
            if (command != null ? !command.equals(that.command) :that.command != null) return false;
            if (environment != null ? !environment.equals(that.environment) :that.environment != null) return false;
            if (image != null ? !image.equals(that.image) :that.image != null) return false;
            return true;
    }


    public class EnvironmentNestedImpl<N> extends EnvVarFluentImpl<CustomDeploymentStrategyParamsFluent.EnvironmentNested<N>> implements CustomDeploymentStrategyParamsFluent.EnvironmentNested<N>,Nested<N>{

            private final EnvVarBuilder builder;
    
            EnvironmentNestedImpl(EnvVar item){
                    this.builder = new EnvVarBuilder(this, item);
            }
            EnvironmentNestedImpl(){
                    this.builder = new EnvVarBuilder(this);
            }
    
    public N endEnvironment(){
            return and();
    }
    public N and(){
            return (N) CustomDeploymentStrategyParamsFluentImpl.this.addToEnvironment(builder.build());
    }

}


}
