package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Integer;
import java.lang.Long;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

public interface DeploymentFluent<A extends DeploymentFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public DeploymentFluent.MetadataNested<A> withNewMetadata();
    public DeploymentFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public DeploymentFluent.MetadataNested<A> editMetadata();
    public DeploymentSpec getSpec();
    public A withSpec(DeploymentSpec spec);
    public DeploymentFluent.SpecNested<A> withNewSpec();
    public DeploymentFluent.SpecNested<A> withNewSpecLike(DeploymentSpec item);
    public DeploymentFluent.SpecNested<A> editSpec();
    public DeploymentStatus getStatus();
    public A withStatus(DeploymentStatus status);
    public DeploymentFluent.StatusNested<A> withNewStatus();
    public DeploymentFluent.StatusNested<A> withNewStatusLike(DeploymentStatus item);
    public DeploymentFluent.StatusNested<A> editStatus();
    public A withNewStatus(Integer availableReplicas,Long observedGeneration,Integer replicas,Integer unavailableReplicas,Integer updatedReplicas);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<DeploymentFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,DeploymentSpecFluent<DeploymentFluent.SpecNested<N>>{

        
    public N endSpec();    public N and();
}
    public interface StatusNested<N> extends Nested<N>,DeploymentStatusFluent<DeploymentFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
