package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.lang.Integer;
import java.lang.Boolean;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class VolumeFluentImpl<A extends VolumeFluent<A>> extends BaseFluent<A> implements VolumeFluent<A>{

    private VisitableBuilder<? extends AWSElasticBlockStoreVolumeSource,?> awsElasticBlockStore;
    private VisitableBuilder<? extends AzureFileVolumeSource,?> azureFile;
    private VisitableBuilder<? extends CephFSVolumeSource,?> cephfs;
    private VisitableBuilder<? extends CinderVolumeSource,?> cinder;
    private VisitableBuilder<? extends ConfigMapVolumeSource,?> configMap;
    private VisitableBuilder<? extends DownwardAPIVolumeSource,?> downwardAPI;
    private VisitableBuilder<? extends EmptyDirVolumeSource,?> emptyDir;
    private VisitableBuilder<? extends FCVolumeSource,?> fc;
    private VisitableBuilder<? extends FlexVolumeSource,?> flexVolume;
    private VisitableBuilder<? extends FlockerVolumeSource,?> flocker;
    private VisitableBuilder<? extends GCEPersistentDiskVolumeSource,?> gcePersistentDisk;
    private VisitableBuilder<? extends GitRepoVolumeSource,?> gitRepo;
    private VisitableBuilder<? extends GlusterfsVolumeSource,?> glusterfs;
    private VisitableBuilder<? extends HostPathVolumeSource,?> hostPath;
    private VisitableBuilder<? extends ISCSIVolumeSource,?> iscsi;
    private VisitableBuilder<? extends DeprecatedDownwardAPIVolumeSource,?> metadata;
    private String name;
    private VisitableBuilder<? extends NFSVolumeSource,?> nfs;
    private VisitableBuilder<? extends PersistentVolumeClaimVolumeSource,?> persistentVolumeClaim;
    private VisitableBuilder<? extends RBDVolumeSource,?> rbd;
    private VisitableBuilder<? extends SecretVolumeSource,?> secret;
    private VisitableBuilder<? extends VsphereVirtualDiskVolumeSource,?> vsphereVolume;

    public VolumeFluentImpl(){
    }
    public VolumeFluentImpl(Volume instance){
            this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore()); 
            this.withAzureFile(instance.getAzureFile()); 
            this.withCephfs(instance.getCephfs()); 
            this.withCinder(instance.getCinder()); 
            this.withConfigMap(instance.getConfigMap()); 
            this.withDownwardAPI(instance.getDownwardAPI()); 
            this.withEmptyDir(instance.getEmptyDir()); 
            this.withFc(instance.getFc()); 
            this.withFlexVolume(instance.getFlexVolume()); 
            this.withFlocker(instance.getFlocker()); 
            this.withGcePersistentDisk(instance.getGcePersistentDisk()); 
            this.withGitRepo(instance.getGitRepo()); 
            this.withGlusterfs(instance.getGlusterfs()); 
            this.withHostPath(instance.getHostPath()); 
            this.withIscsi(instance.getIscsi()); 
            this.withMetadata(instance.getMetadata()); 
            this.withName(instance.getName()); 
            this.withNfs(instance.getNfs()); 
            this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim()); 
            this.withRbd(instance.getRbd()); 
            this.withSecret(instance.getSecret()); 
            this.withVsphereVolume(instance.getVsphereVolume()); 
    }

    public AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore(){
            return this.awsElasticBlockStore!=null?this.awsElasticBlockStore.build():null;
    }

    public A withAwsElasticBlockStore(AWSElasticBlockStoreVolumeSource awsElasticBlockStore){
            if (awsElasticBlockStore!=null){ this.awsElasticBlockStore= new AWSElasticBlockStoreVolumeSourceBuilder(awsElasticBlockStore); _visitables.add(this.awsElasticBlockStore);} return (A) this;
    }

    public VolumeFluent.AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStore(){
            return new AwsElasticBlockStoreNestedImpl();
    }

    public VolumeFluent.AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStoreLike(AWSElasticBlockStoreVolumeSource item){
            return new AwsElasticBlockStoreNestedImpl(item);
    }

    public VolumeFluent.AwsElasticBlockStoreNested<A> editAwsElasticBlockStore(){
            return withNewAwsElasticBlockStoreLike(getAwsElasticBlockStore());
    }

    public A withNewAwsElasticBlockStore(String fsType,Integer partition,Boolean readOnly,String volumeID){
            return (A)withAwsElasticBlockStore(new AWSElasticBlockStoreVolumeSource(fsType, partition, readOnly, volumeID));
    }

    public AzureFileVolumeSource getAzureFile(){
            return this.azureFile!=null?this.azureFile.build():null;
    }

    public A withAzureFile(AzureFileVolumeSource azureFile){
            if (azureFile!=null){ this.azureFile= new AzureFileVolumeSourceBuilder(azureFile); _visitables.add(this.azureFile);} return (A) this;
    }

    public VolumeFluent.AzureFileNested<A> withNewAzureFile(){
            return new AzureFileNestedImpl();
    }

    public VolumeFluent.AzureFileNested<A> withNewAzureFileLike(AzureFileVolumeSource item){
            return new AzureFileNestedImpl(item);
    }

    public VolumeFluent.AzureFileNested<A> editAzureFile(){
            return withNewAzureFileLike(getAzureFile());
    }

    public A withNewAzureFile(Boolean readOnly,String secretName,String shareName){
            return (A)withAzureFile(new AzureFileVolumeSource(readOnly, secretName, shareName));
    }

    public CephFSVolumeSource getCephfs(){
            return this.cephfs!=null?this.cephfs.build():null;
    }

    public A withCephfs(CephFSVolumeSource cephfs){
            if (cephfs!=null){ this.cephfs= new CephFSVolumeSourceBuilder(cephfs); _visitables.add(this.cephfs);} return (A) this;
    }

    public VolumeFluent.CephfsNested<A> withNewCephfs(){
            return new CephfsNestedImpl();
    }

    public VolumeFluent.CephfsNested<A> withNewCephfsLike(CephFSVolumeSource item){
            return new CephfsNestedImpl(item);
    }

    public VolumeFluent.CephfsNested<A> editCephfs(){
            return withNewCephfsLike(getCephfs());
    }

    public CinderVolumeSource getCinder(){
            return this.cinder!=null?this.cinder.build():null;
    }

    public A withCinder(CinderVolumeSource cinder){
            if (cinder!=null){ this.cinder= new CinderVolumeSourceBuilder(cinder); _visitables.add(this.cinder);} return (A) this;
    }

    public VolumeFluent.CinderNested<A> withNewCinder(){
            return new CinderNestedImpl();
    }

    public VolumeFluent.CinderNested<A> withNewCinderLike(CinderVolumeSource item){
            return new CinderNestedImpl(item);
    }

    public VolumeFluent.CinderNested<A> editCinder(){
            return withNewCinderLike(getCinder());
    }

    public A withNewCinder(String fsType,Boolean readOnly,String volumeID){
            return (A)withCinder(new CinderVolumeSource(fsType, readOnly, volumeID));
    }

    public ConfigMapVolumeSource getConfigMap(){
            return this.configMap!=null?this.configMap.build():null;
    }

    public A withConfigMap(ConfigMapVolumeSource configMap){
            if (configMap!=null){ this.configMap= new ConfigMapVolumeSourceBuilder(configMap); _visitables.add(this.configMap);} return (A) this;
    }

    public VolumeFluent.ConfigMapNested<A> withNewConfigMap(){
            return new ConfigMapNestedImpl();
    }

    public VolumeFluent.ConfigMapNested<A> withNewConfigMapLike(ConfigMapVolumeSource item){
            return new ConfigMapNestedImpl(item);
    }

    public VolumeFluent.ConfigMapNested<A> editConfigMap(){
            return withNewConfigMapLike(getConfigMap());
    }

    public DownwardAPIVolumeSource getDownwardAPI(){
            return this.downwardAPI!=null?this.downwardAPI.build():null;
    }

    public A withDownwardAPI(DownwardAPIVolumeSource downwardAPI){
            if (downwardAPI!=null){ this.downwardAPI= new DownwardAPIVolumeSourceBuilder(downwardAPI); _visitables.add(this.downwardAPI);} return (A) this;
    }

    public VolumeFluent.DownwardAPINested<A> withNewDownwardAPI(){
            return new DownwardAPINestedImpl();
    }

    public VolumeFluent.DownwardAPINested<A> withNewDownwardAPILike(DownwardAPIVolumeSource item){
            return new DownwardAPINestedImpl(item);
    }

    public VolumeFluent.DownwardAPINested<A> editDownwardAPI(){
            return withNewDownwardAPILike(getDownwardAPI());
    }

    public EmptyDirVolumeSource getEmptyDir(){
            return this.emptyDir!=null?this.emptyDir.build():null;
    }

    public A withEmptyDir(EmptyDirVolumeSource emptyDir){
            if (emptyDir!=null){ this.emptyDir= new EmptyDirVolumeSourceBuilder(emptyDir); _visitables.add(this.emptyDir);} return (A) this;
    }

    public VolumeFluent.EmptyDirNested<A> withNewEmptyDir(){
            return new EmptyDirNestedImpl();
    }

    public VolumeFluent.EmptyDirNested<A> withNewEmptyDirLike(EmptyDirVolumeSource item){
            return new EmptyDirNestedImpl(item);
    }

    public VolumeFluent.EmptyDirNested<A> editEmptyDir(){
            return withNewEmptyDirLike(getEmptyDir());
    }

    public A withNewEmptyDir(String medium){
            return (A)withEmptyDir(new EmptyDirVolumeSource(medium));
    }

    public FCVolumeSource getFc(){
            return this.fc!=null?this.fc.build():null;
    }

    public A withFc(FCVolumeSource fc){
            if (fc!=null){ this.fc= new FCVolumeSourceBuilder(fc); _visitables.add(this.fc);} return (A) this;
    }

    public VolumeFluent.FcNested<A> withNewFc(){
            return new FcNestedImpl();
    }

    public VolumeFluent.FcNested<A> withNewFcLike(FCVolumeSource item){
            return new FcNestedImpl(item);
    }

    public VolumeFluent.FcNested<A> editFc(){
            return withNewFcLike(getFc());
    }

    public FlexVolumeSource getFlexVolume(){
            return this.flexVolume!=null?this.flexVolume.build():null;
    }

    public A withFlexVolume(FlexVolumeSource flexVolume){
            if (flexVolume!=null){ this.flexVolume= new FlexVolumeSourceBuilder(flexVolume); _visitables.add(this.flexVolume);} return (A) this;
    }

    public VolumeFluent.FlexVolumeNested<A> withNewFlexVolume(){
            return new FlexVolumeNestedImpl();
    }

    public VolumeFluent.FlexVolumeNested<A> withNewFlexVolumeLike(FlexVolumeSource item){
            return new FlexVolumeNestedImpl(item);
    }

    public VolumeFluent.FlexVolumeNested<A> editFlexVolume(){
            return withNewFlexVolumeLike(getFlexVolume());
    }

    public FlockerVolumeSource getFlocker(){
            return this.flocker!=null?this.flocker.build():null;
    }

    public A withFlocker(FlockerVolumeSource flocker){
            if (flocker!=null){ this.flocker= new FlockerVolumeSourceBuilder(flocker); _visitables.add(this.flocker);} return (A) this;
    }

    public VolumeFluent.FlockerNested<A> withNewFlocker(){
            return new FlockerNestedImpl();
    }

    public VolumeFluent.FlockerNested<A> withNewFlockerLike(FlockerVolumeSource item){
            return new FlockerNestedImpl(item);
    }

    public VolumeFluent.FlockerNested<A> editFlocker(){
            return withNewFlockerLike(getFlocker());
    }

    public A withNewFlocker(String datasetName){
            return (A)withFlocker(new FlockerVolumeSource(datasetName));
    }

    public GCEPersistentDiskVolumeSource getGcePersistentDisk(){
            return this.gcePersistentDisk!=null?this.gcePersistentDisk.build():null;
    }

    public A withGcePersistentDisk(GCEPersistentDiskVolumeSource gcePersistentDisk){
            if (gcePersistentDisk!=null){ this.gcePersistentDisk= new GCEPersistentDiskVolumeSourceBuilder(gcePersistentDisk); _visitables.add(this.gcePersistentDisk);} return (A) this;
    }

    public VolumeFluent.GcePersistentDiskNested<A> withNewGcePersistentDisk(){
            return new GcePersistentDiskNestedImpl();
    }

    public VolumeFluent.GcePersistentDiskNested<A> withNewGcePersistentDiskLike(GCEPersistentDiskVolumeSource item){
            return new GcePersistentDiskNestedImpl(item);
    }

    public VolumeFluent.GcePersistentDiskNested<A> editGcePersistentDisk(){
            return withNewGcePersistentDiskLike(getGcePersistentDisk());
    }

    public A withNewGcePersistentDisk(String fsType,Integer partition,String pdName,Boolean readOnly){
            return (A)withGcePersistentDisk(new GCEPersistentDiskVolumeSource(fsType, partition, pdName, readOnly));
    }

    public GitRepoVolumeSource getGitRepo(){
            return this.gitRepo!=null?this.gitRepo.build():null;
    }

    public A withGitRepo(GitRepoVolumeSource gitRepo){
            if (gitRepo!=null){ this.gitRepo= new GitRepoVolumeSourceBuilder(gitRepo); _visitables.add(this.gitRepo);} return (A) this;
    }

    public VolumeFluent.GitRepoNested<A> withNewGitRepo(){
            return new GitRepoNestedImpl();
    }

    public VolumeFluent.GitRepoNested<A> withNewGitRepoLike(GitRepoVolumeSource item){
            return new GitRepoNestedImpl(item);
    }

    public VolumeFluent.GitRepoNested<A> editGitRepo(){
            return withNewGitRepoLike(getGitRepo());
    }

    public A withNewGitRepo(String directory,String repository,String revision){
            return (A)withGitRepo(new GitRepoVolumeSource(directory, repository, revision));
    }

    public GlusterfsVolumeSource getGlusterfs(){
            return this.glusterfs!=null?this.glusterfs.build():null;
    }

    public A withGlusterfs(GlusterfsVolumeSource glusterfs){
            if (glusterfs!=null){ this.glusterfs= new GlusterfsVolumeSourceBuilder(glusterfs); _visitables.add(this.glusterfs);} return (A) this;
    }

    public VolumeFluent.GlusterfsNested<A> withNewGlusterfs(){
            return new GlusterfsNestedImpl();
    }

    public VolumeFluent.GlusterfsNested<A> withNewGlusterfsLike(GlusterfsVolumeSource item){
            return new GlusterfsNestedImpl(item);
    }

    public VolumeFluent.GlusterfsNested<A> editGlusterfs(){
            return withNewGlusterfsLike(getGlusterfs());
    }

    public A withNewGlusterfs(String endpoints,String path,Boolean readOnly){
            return (A)withGlusterfs(new GlusterfsVolumeSource(endpoints, path, readOnly));
    }

    public HostPathVolumeSource getHostPath(){
            return this.hostPath!=null?this.hostPath.build():null;
    }

    public A withHostPath(HostPathVolumeSource hostPath){
            if (hostPath!=null){ this.hostPath= new HostPathVolumeSourceBuilder(hostPath); _visitables.add(this.hostPath);} return (A) this;
    }

    public VolumeFluent.HostPathNested<A> withNewHostPath(){
            return new HostPathNestedImpl();
    }

    public VolumeFluent.HostPathNested<A> withNewHostPathLike(HostPathVolumeSource item){
            return new HostPathNestedImpl(item);
    }

    public VolumeFluent.HostPathNested<A> editHostPath(){
            return withNewHostPathLike(getHostPath());
    }

    public A withNewHostPath(String path){
            return (A)withHostPath(new HostPathVolumeSource(path));
    }

    public ISCSIVolumeSource getIscsi(){
            return this.iscsi!=null?this.iscsi.build():null;
    }

    public A withIscsi(ISCSIVolumeSource iscsi){
            if (iscsi!=null){ this.iscsi= new ISCSIVolumeSourceBuilder(iscsi); _visitables.add(this.iscsi);} return (A) this;
    }

    public VolumeFluent.IscsiNested<A> withNewIscsi(){
            return new IscsiNestedImpl();
    }

    public VolumeFluent.IscsiNested<A> withNewIscsiLike(ISCSIVolumeSource item){
            return new IscsiNestedImpl(item);
    }

    public VolumeFluent.IscsiNested<A> editIscsi(){
            return withNewIscsiLike(getIscsi());
    }

    public DeprecatedDownwardAPIVolumeSource getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(DeprecatedDownwardAPIVolumeSource metadata){
            if (metadata!=null){ this.metadata= new DeprecatedDownwardAPIVolumeSourceBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public VolumeFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public VolumeFluent.MetadataNested<A> withNewMetadataLike(DeprecatedDownwardAPIVolumeSource item){
            return new MetadataNestedImpl(item);
    }

    public VolumeFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public NFSVolumeSource getNfs(){
            return this.nfs!=null?this.nfs.build():null;
    }

    public A withNfs(NFSVolumeSource nfs){
            if (nfs!=null){ this.nfs= new NFSVolumeSourceBuilder(nfs); _visitables.add(this.nfs);} return (A) this;
    }

    public VolumeFluent.NfsNested<A> withNewNfs(){
            return new NfsNestedImpl();
    }

    public VolumeFluent.NfsNested<A> withNewNfsLike(NFSVolumeSource item){
            return new NfsNestedImpl(item);
    }

    public VolumeFluent.NfsNested<A> editNfs(){
            return withNewNfsLike(getNfs());
    }

    public A withNewNfs(String path,Boolean readOnly,String server){
            return (A)withNfs(new NFSVolumeSource(path, readOnly, server));
    }

    public PersistentVolumeClaimVolumeSource getPersistentVolumeClaim(){
            return this.persistentVolumeClaim!=null?this.persistentVolumeClaim.build():null;
    }

    public A withPersistentVolumeClaim(PersistentVolumeClaimVolumeSource persistentVolumeClaim){
            if (persistentVolumeClaim!=null){ this.persistentVolumeClaim= new PersistentVolumeClaimVolumeSourceBuilder(persistentVolumeClaim); _visitables.add(this.persistentVolumeClaim);} return (A) this;
    }

    public VolumeFluent.PersistentVolumeClaimNested<A> withNewPersistentVolumeClaim(){
            return new PersistentVolumeClaimNestedImpl();
    }

    public VolumeFluent.PersistentVolumeClaimNested<A> withNewPersistentVolumeClaimLike(PersistentVolumeClaimVolumeSource item){
            return new PersistentVolumeClaimNestedImpl(item);
    }

    public VolumeFluent.PersistentVolumeClaimNested<A> editPersistentVolumeClaim(){
            return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim());
    }

    public A withNewPersistentVolumeClaim(String claimName,Boolean readOnly){
            return (A)withPersistentVolumeClaim(new PersistentVolumeClaimVolumeSource(claimName, readOnly));
    }

    public RBDVolumeSource getRbd(){
            return this.rbd!=null?this.rbd.build():null;
    }

    public A withRbd(RBDVolumeSource rbd){
            if (rbd!=null){ this.rbd= new RBDVolumeSourceBuilder(rbd); _visitables.add(this.rbd);} return (A) this;
    }

    public VolumeFluent.RbdNested<A> withNewRbd(){
            return new RbdNestedImpl();
    }

    public VolumeFluent.RbdNested<A> withNewRbdLike(RBDVolumeSource item){
            return new RbdNestedImpl(item);
    }

    public VolumeFluent.RbdNested<A> editRbd(){
            return withNewRbdLike(getRbd());
    }

    public SecretVolumeSource getSecret(){
            return this.secret!=null?this.secret.build():null;
    }

    public A withSecret(SecretVolumeSource secret){
            if (secret!=null){ this.secret= new SecretVolumeSourceBuilder(secret); _visitables.add(this.secret);} return (A) this;
    }

    public VolumeFluent.SecretNested<A> withNewSecret(){
            return new SecretNestedImpl();
    }

    public VolumeFluent.SecretNested<A> withNewSecretLike(SecretVolumeSource item){
            return new SecretNestedImpl(item);
    }

    public VolumeFluent.SecretNested<A> editSecret(){
            return withNewSecretLike(getSecret());
    }

    public VsphereVirtualDiskVolumeSource getVsphereVolume(){
            return this.vsphereVolume!=null?this.vsphereVolume.build():null;
    }

    public A withVsphereVolume(VsphereVirtualDiskVolumeSource vsphereVolume){
            if (vsphereVolume!=null){ this.vsphereVolume= new VsphereVirtualDiskVolumeSourceBuilder(vsphereVolume); _visitables.add(this.vsphereVolume);} return (A) this;
    }

    public VolumeFluent.VsphereVolumeNested<A> withNewVsphereVolume(){
            return new VsphereVolumeNestedImpl();
    }

    public VolumeFluent.VsphereVolumeNested<A> withNewVsphereVolumeLike(VsphereVirtualDiskVolumeSource item){
            return new VsphereVolumeNestedImpl(item);
    }

    public VolumeFluent.VsphereVolumeNested<A> editVsphereVolume(){
            return withNewVsphereVolumeLike(getVsphereVolume());
    }

    public A withNewVsphereVolume(String fsType,String volumePath){
            return (A)withVsphereVolume(new VsphereVirtualDiskVolumeSource(fsType, volumePath));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            VolumeFluentImpl that = (VolumeFluentImpl) o;
            if (awsElasticBlockStore != null ? !awsElasticBlockStore.equals(that.awsElasticBlockStore) :that.awsElasticBlockStore != null) return false;
            if (azureFile != null ? !azureFile.equals(that.azureFile) :that.azureFile != null) return false;
            if (cephfs != null ? !cephfs.equals(that.cephfs) :that.cephfs != null) return false;
            if (cinder != null ? !cinder.equals(that.cinder) :that.cinder != null) return false;
            if (configMap != null ? !configMap.equals(that.configMap) :that.configMap != null) return false;
            if (downwardAPI != null ? !downwardAPI.equals(that.downwardAPI) :that.downwardAPI != null) return false;
            if (emptyDir != null ? !emptyDir.equals(that.emptyDir) :that.emptyDir != null) return false;
            if (fc != null ? !fc.equals(that.fc) :that.fc != null) return false;
            if (flexVolume != null ? !flexVolume.equals(that.flexVolume) :that.flexVolume != null) return false;
            if (flocker != null ? !flocker.equals(that.flocker) :that.flocker != null) return false;
            if (gcePersistentDisk != null ? !gcePersistentDisk.equals(that.gcePersistentDisk) :that.gcePersistentDisk != null) return false;
            if (gitRepo != null ? !gitRepo.equals(that.gitRepo) :that.gitRepo != null) return false;
            if (glusterfs != null ? !glusterfs.equals(that.glusterfs) :that.glusterfs != null) return false;
            if (hostPath != null ? !hostPath.equals(that.hostPath) :that.hostPath != null) return false;
            if (iscsi != null ? !iscsi.equals(that.iscsi) :that.iscsi != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (nfs != null ? !nfs.equals(that.nfs) :that.nfs != null) return false;
            if (persistentVolumeClaim != null ? !persistentVolumeClaim.equals(that.persistentVolumeClaim) :that.persistentVolumeClaim != null) return false;
            if (rbd != null ? !rbd.equals(that.rbd) :that.rbd != null) return false;
            if (secret != null ? !secret.equals(that.secret) :that.secret != null) return false;
            if (vsphereVolume != null ? !vsphereVolume.equals(that.vsphereVolume) :that.vsphereVolume != null) return false;
            return true;
    }


    public class AwsElasticBlockStoreNestedImpl<N> extends AWSElasticBlockStoreVolumeSourceFluentImpl<VolumeFluent.AwsElasticBlockStoreNested<N>> implements VolumeFluent.AwsElasticBlockStoreNested<N>,Nested<N>{

            private final AWSElasticBlockStoreVolumeSourceBuilder builder;
    
            AwsElasticBlockStoreNestedImpl(AWSElasticBlockStoreVolumeSource item){
                    this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this, item);
            }
            AwsElasticBlockStoreNestedImpl(){
                    this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this);
            }
    
    public N endAwsElasticBlockStore(){
            return and();
    }
    public N and(){
            return (N) VolumeFluentImpl.this.withAwsElasticBlockStore(builder.build());
    }

}
    public class AzureFileNestedImpl<N> extends AzureFileVolumeSourceFluentImpl<VolumeFluent.AzureFileNested<N>> implements VolumeFluent.AzureFileNested<N>,Nested<N>{

            private final AzureFileVolumeSourceBuilder builder;
    
            AzureFileNestedImpl(AzureFileVolumeSource item){
                    this.builder = new AzureFileVolumeSourceBuilder(this, item);
            }
            AzureFileNestedImpl(){
                    this.builder = new AzureFileVolumeSourceBuilder(this);
            }
    
    public N endAzureFile(){
            return and();
    }
    public N and(){
            return (N) VolumeFluentImpl.this.withAzureFile(builder.build());
    }

}
    public class CephfsNestedImpl<N> extends CephFSVolumeSourceFluentImpl<VolumeFluent.CephfsNested<N>> implements VolumeFluent.CephfsNested<N>,Nested<N>{

            private final CephFSVolumeSourceBuilder builder;
    
            CephfsNestedImpl(){
                    this.builder = new CephFSVolumeSourceBuilder(this);
            }
            CephfsNestedImpl(CephFSVolumeSource item){
                    this.builder = new CephFSVolumeSourceBuilder(this, item);
            }
    
    public N endCephfs(){
            return and();
    }
    public N and(){
            return (N) VolumeFluentImpl.this.withCephfs(builder.build());
    }

}
    public class CinderNestedImpl<N> extends CinderVolumeSourceFluentImpl<VolumeFluent.CinderNested<N>> implements VolumeFluent.CinderNested<N>,Nested<N>{

            private final CinderVolumeSourceBuilder builder;
    
            CinderNestedImpl(){
                    this.builder = new CinderVolumeSourceBuilder(this);
            }
            CinderNestedImpl(CinderVolumeSource item){
                    this.builder = new CinderVolumeSourceBuilder(this, item);
            }
    
    public N and(){
            return (N) VolumeFluentImpl.this.withCinder(builder.build());
    }
    public N endCinder(){
            return and();
    }

}
    public class ConfigMapNestedImpl<N> extends ConfigMapVolumeSourceFluentImpl<VolumeFluent.ConfigMapNested<N>> implements VolumeFluent.ConfigMapNested<N>,Nested<N>{

            private final ConfigMapVolumeSourceBuilder builder;
    
            ConfigMapNestedImpl(){
                    this.builder = new ConfigMapVolumeSourceBuilder(this);
            }
            ConfigMapNestedImpl(ConfigMapVolumeSource item){
                    this.builder = new ConfigMapVolumeSourceBuilder(this, item);
            }
    
    public N and(){
            return (N) VolumeFluentImpl.this.withConfigMap(builder.build());
    }
    public N endConfigMap(){
            return and();
    }

}
    public class DownwardAPINestedImpl<N> extends DownwardAPIVolumeSourceFluentImpl<VolumeFluent.DownwardAPINested<N>> implements VolumeFluent.DownwardAPINested<N>,Nested<N>{

            private final DownwardAPIVolumeSourceBuilder builder;
    
            DownwardAPINestedImpl(){
                    this.builder = new DownwardAPIVolumeSourceBuilder(this);
            }
            DownwardAPINestedImpl(DownwardAPIVolumeSource item){
                    this.builder = new DownwardAPIVolumeSourceBuilder(this, item);
            }
    
    public N endDownwardAPI(){
            return and();
    }
    public N and(){
            return (N) VolumeFluentImpl.this.withDownwardAPI(builder.build());
    }

}
    public class EmptyDirNestedImpl<N> extends EmptyDirVolumeSourceFluentImpl<VolumeFluent.EmptyDirNested<N>> implements VolumeFluent.EmptyDirNested<N>,Nested<N>{

            private final EmptyDirVolumeSourceBuilder builder;
    
            EmptyDirNestedImpl(){
                    this.builder = new EmptyDirVolumeSourceBuilder(this);
            }
            EmptyDirNestedImpl(EmptyDirVolumeSource item){
                    this.builder = new EmptyDirVolumeSourceBuilder(this, item);
            }
    
    public N endEmptyDir(){
            return and();
    }
    public N and(){
            return (N) VolumeFluentImpl.this.withEmptyDir(builder.build());
    }

}
    public class FcNestedImpl<N> extends FCVolumeSourceFluentImpl<VolumeFluent.FcNested<N>> implements VolumeFluent.FcNested<N>,Nested<N>{

            private final FCVolumeSourceBuilder builder;
    
            FcNestedImpl(FCVolumeSource item){
                    this.builder = new FCVolumeSourceBuilder(this, item);
            }
            FcNestedImpl(){
                    this.builder = new FCVolumeSourceBuilder(this);
            }
    
    public N and(){
            return (N) VolumeFluentImpl.this.withFc(builder.build());
    }
    public N endFc(){
            return and();
    }

}
    public class FlexVolumeNestedImpl<N> extends FlexVolumeSourceFluentImpl<VolumeFluent.FlexVolumeNested<N>> implements VolumeFluent.FlexVolumeNested<N>,Nested<N>{

            private final FlexVolumeSourceBuilder builder;
    
            FlexVolumeNestedImpl(){
                    this.builder = new FlexVolumeSourceBuilder(this);
            }
            FlexVolumeNestedImpl(FlexVolumeSource item){
                    this.builder = new FlexVolumeSourceBuilder(this, item);
            }
    
    public N and(){
            return (N) VolumeFluentImpl.this.withFlexVolume(builder.build());
    }
    public N endFlexVolume(){
            return and();
    }

}
    public class FlockerNestedImpl<N> extends FlockerVolumeSourceFluentImpl<VolumeFluent.FlockerNested<N>> implements VolumeFluent.FlockerNested<N>,Nested<N>{

            private final FlockerVolumeSourceBuilder builder;
    
            FlockerNestedImpl(){
                    this.builder = new FlockerVolumeSourceBuilder(this);
            }
            FlockerNestedImpl(FlockerVolumeSource item){
                    this.builder = new FlockerVolumeSourceBuilder(this, item);
            }
    
    public N and(){
            return (N) VolumeFluentImpl.this.withFlocker(builder.build());
    }
    public N endFlocker(){
            return and();
    }

}
    public class GcePersistentDiskNestedImpl<N> extends GCEPersistentDiskVolumeSourceFluentImpl<VolumeFluent.GcePersistentDiskNested<N>> implements VolumeFluent.GcePersistentDiskNested<N>,Nested<N>{

            private final GCEPersistentDiskVolumeSourceBuilder builder;
    
            GcePersistentDiskNestedImpl(){
                    this.builder = new GCEPersistentDiskVolumeSourceBuilder(this);
            }
            GcePersistentDiskNestedImpl(GCEPersistentDiskVolumeSource item){
                    this.builder = new GCEPersistentDiskVolumeSourceBuilder(this, item);
            }
    
    public N endGcePersistentDisk(){
            return and();
    }
    public N and(){
            return (N) VolumeFluentImpl.this.withGcePersistentDisk(builder.build());
    }

}
    public class GitRepoNestedImpl<N> extends GitRepoVolumeSourceFluentImpl<VolumeFluent.GitRepoNested<N>> implements VolumeFluent.GitRepoNested<N>,Nested<N>{

            private final GitRepoVolumeSourceBuilder builder;
    
            GitRepoNestedImpl(){
                    this.builder = new GitRepoVolumeSourceBuilder(this);
            }
            GitRepoNestedImpl(GitRepoVolumeSource item){
                    this.builder = new GitRepoVolumeSourceBuilder(this, item);
            }
    
    public N endGitRepo(){
            return and();
    }
    public N and(){
            return (N) VolumeFluentImpl.this.withGitRepo(builder.build());
    }

}
    public class GlusterfsNestedImpl<N> extends GlusterfsVolumeSourceFluentImpl<VolumeFluent.GlusterfsNested<N>> implements VolumeFluent.GlusterfsNested<N>,Nested<N>{

            private final GlusterfsVolumeSourceBuilder builder;
    
            GlusterfsNestedImpl(){
                    this.builder = new GlusterfsVolumeSourceBuilder(this);
            }
            GlusterfsNestedImpl(GlusterfsVolumeSource item){
                    this.builder = new GlusterfsVolumeSourceBuilder(this, item);
            }
    
    public N and(){
            return (N) VolumeFluentImpl.this.withGlusterfs(builder.build());
    }
    public N endGlusterfs(){
            return and();
    }

}
    public class HostPathNestedImpl<N> extends HostPathVolumeSourceFluentImpl<VolumeFluent.HostPathNested<N>> implements VolumeFluent.HostPathNested<N>,Nested<N>{

            private final HostPathVolumeSourceBuilder builder;
    
            HostPathNestedImpl(){
                    this.builder = new HostPathVolumeSourceBuilder(this);
            }
            HostPathNestedImpl(HostPathVolumeSource item){
                    this.builder = new HostPathVolumeSourceBuilder(this, item);
            }
    
    public N and(){
            return (N) VolumeFluentImpl.this.withHostPath(builder.build());
    }
    public N endHostPath(){
            return and();
    }

}
    public class IscsiNestedImpl<N> extends ISCSIVolumeSourceFluentImpl<VolumeFluent.IscsiNested<N>> implements VolumeFluent.IscsiNested<N>,Nested<N>{

            private final ISCSIVolumeSourceBuilder builder;
    
            IscsiNestedImpl(ISCSIVolumeSource item){
                    this.builder = new ISCSIVolumeSourceBuilder(this, item);
            }
            IscsiNestedImpl(){
                    this.builder = new ISCSIVolumeSourceBuilder(this);
            }
    
    public N and(){
            return (N) VolumeFluentImpl.this.withIscsi(builder.build());
    }
    public N endIscsi(){
            return and();
    }

}
    public class MetadataNestedImpl<N> extends DeprecatedDownwardAPIVolumeSourceFluentImpl<VolumeFluent.MetadataNested<N>> implements VolumeFluent.MetadataNested<N>,Nested<N>{

            private final DeprecatedDownwardAPIVolumeSourceBuilder builder;
    
            MetadataNestedImpl(DeprecatedDownwardAPIVolumeSource item){
                    this.builder = new DeprecatedDownwardAPIVolumeSourceBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new DeprecatedDownwardAPIVolumeSourceBuilder(this);
            }
    
    public N and(){
            return (N) VolumeFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class NfsNestedImpl<N> extends NFSVolumeSourceFluentImpl<VolumeFluent.NfsNested<N>> implements VolumeFluent.NfsNested<N>,Nested<N>{

            private final NFSVolumeSourceBuilder builder;
    
            NfsNestedImpl(NFSVolumeSource item){
                    this.builder = new NFSVolumeSourceBuilder(this, item);
            }
            NfsNestedImpl(){
                    this.builder = new NFSVolumeSourceBuilder(this);
            }
    
    public N endNfs(){
            return and();
    }
    public N and(){
            return (N) VolumeFluentImpl.this.withNfs(builder.build());
    }

}
    public class PersistentVolumeClaimNestedImpl<N> extends PersistentVolumeClaimVolumeSourceFluentImpl<VolumeFluent.PersistentVolumeClaimNested<N>> implements VolumeFluent.PersistentVolumeClaimNested<N>,Nested<N>{

            private final PersistentVolumeClaimVolumeSourceBuilder builder;
    
            PersistentVolumeClaimNestedImpl(){
                    this.builder = new PersistentVolumeClaimVolumeSourceBuilder(this);
            }
            PersistentVolumeClaimNestedImpl(PersistentVolumeClaimVolumeSource item){
                    this.builder = new PersistentVolumeClaimVolumeSourceBuilder(this, item);
            }
    
    public N endPersistentVolumeClaim(){
            return and();
    }
    public N and(){
            return (N) VolumeFluentImpl.this.withPersistentVolumeClaim(builder.build());
    }

}
    public class RbdNestedImpl<N> extends RBDVolumeSourceFluentImpl<VolumeFluent.RbdNested<N>> implements VolumeFluent.RbdNested<N>,Nested<N>{

            private final RBDVolumeSourceBuilder builder;
    
            RbdNestedImpl(){
                    this.builder = new RBDVolumeSourceBuilder(this);
            }
            RbdNestedImpl(RBDVolumeSource item){
                    this.builder = new RBDVolumeSourceBuilder(this, item);
            }
    
    public N and(){
            return (N) VolumeFluentImpl.this.withRbd(builder.build());
    }
    public N endRbd(){
            return and();
    }

}
    public class SecretNestedImpl<N> extends SecretVolumeSourceFluentImpl<VolumeFluent.SecretNested<N>> implements VolumeFluent.SecretNested<N>,Nested<N>{

            private final SecretVolumeSourceBuilder builder;
    
            SecretNestedImpl(){
                    this.builder = new SecretVolumeSourceBuilder(this);
            }
            SecretNestedImpl(SecretVolumeSource item){
                    this.builder = new SecretVolumeSourceBuilder(this, item);
            }
    
    public N and(){
            return (N) VolumeFluentImpl.this.withSecret(builder.build());
    }
    public N endSecret(){
            return and();
    }

}
    public class VsphereVolumeNestedImpl<N> extends VsphereVirtualDiskVolumeSourceFluentImpl<VolumeFluent.VsphereVolumeNested<N>> implements VolumeFluent.VsphereVolumeNested<N>,Nested<N>{

            private final VsphereVirtualDiskVolumeSourceBuilder builder;
    
            VsphereVolumeNestedImpl(){
                    this.builder = new VsphereVirtualDiskVolumeSourceBuilder(this);
            }
            VsphereVolumeNestedImpl(VsphereVirtualDiskVolumeSource item){
                    this.builder = new VsphereVirtualDiskVolumeSourceBuilder(this, item);
            }
    
    public N endVsphereVolume(){
            return and();
    }
    public N and(){
            return (N) VolumeFluentImpl.this.withVsphereVolume(builder.build());
    }

}


}
