package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Integer;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Nested;

public interface VolumeFluent<A extends VolumeFluent<A>> extends Fluent<A>{


    public AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore();
    public A withAwsElasticBlockStore(AWSElasticBlockStoreVolumeSource awsElasticBlockStore);
    public VolumeFluent.AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStore();
    public VolumeFluent.AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStoreLike(AWSElasticBlockStoreVolumeSource item);
    public VolumeFluent.AwsElasticBlockStoreNested<A> editAwsElasticBlockStore();
    public A withNewAwsElasticBlockStore(String fsType,Integer partition,Boolean readOnly,String volumeID);
    public AzureFileVolumeSource getAzureFile();
    public A withAzureFile(AzureFileVolumeSource azureFile);
    public VolumeFluent.AzureFileNested<A> withNewAzureFile();
    public VolumeFluent.AzureFileNested<A> withNewAzureFileLike(AzureFileVolumeSource item);
    public VolumeFluent.AzureFileNested<A> editAzureFile();
    public A withNewAzureFile(Boolean readOnly,String secretName,String shareName);
    public CephFSVolumeSource getCephfs();
    public A withCephfs(CephFSVolumeSource cephfs);
    public VolumeFluent.CephfsNested<A> withNewCephfs();
    public VolumeFluent.CephfsNested<A> withNewCephfsLike(CephFSVolumeSource item);
    public VolumeFluent.CephfsNested<A> editCephfs();
    public CinderVolumeSource getCinder();
    public A withCinder(CinderVolumeSource cinder);
    public VolumeFluent.CinderNested<A> withNewCinder();
    public VolumeFluent.CinderNested<A> withNewCinderLike(CinderVolumeSource item);
    public VolumeFluent.CinderNested<A> editCinder();
    public A withNewCinder(String fsType,Boolean readOnly,String volumeID);
    public ConfigMapVolumeSource getConfigMap();
    public A withConfigMap(ConfigMapVolumeSource configMap);
    public VolumeFluent.ConfigMapNested<A> withNewConfigMap();
    public VolumeFluent.ConfigMapNested<A> withNewConfigMapLike(ConfigMapVolumeSource item);
    public VolumeFluent.ConfigMapNested<A> editConfigMap();
    public DownwardAPIVolumeSource getDownwardAPI();
    public A withDownwardAPI(DownwardAPIVolumeSource downwardAPI);
    public VolumeFluent.DownwardAPINested<A> withNewDownwardAPI();
    public VolumeFluent.DownwardAPINested<A> withNewDownwardAPILike(DownwardAPIVolumeSource item);
    public VolumeFluent.DownwardAPINested<A> editDownwardAPI();
    public EmptyDirVolumeSource getEmptyDir();
    public A withEmptyDir(EmptyDirVolumeSource emptyDir);
    public VolumeFluent.EmptyDirNested<A> withNewEmptyDir();
    public VolumeFluent.EmptyDirNested<A> withNewEmptyDirLike(EmptyDirVolumeSource item);
    public VolumeFluent.EmptyDirNested<A> editEmptyDir();
    public A withNewEmptyDir(String medium);
    public FCVolumeSource getFc();
    public A withFc(FCVolumeSource fc);
    public VolumeFluent.FcNested<A> withNewFc();
    public VolumeFluent.FcNested<A> withNewFcLike(FCVolumeSource item);
    public VolumeFluent.FcNested<A> editFc();
    public FlexVolumeSource getFlexVolume();
    public A withFlexVolume(FlexVolumeSource flexVolume);
    public VolumeFluent.FlexVolumeNested<A> withNewFlexVolume();
    public VolumeFluent.FlexVolumeNested<A> withNewFlexVolumeLike(FlexVolumeSource item);
    public VolumeFluent.FlexVolumeNested<A> editFlexVolume();
    public FlockerVolumeSource getFlocker();
    public A withFlocker(FlockerVolumeSource flocker);
    public VolumeFluent.FlockerNested<A> withNewFlocker();
    public VolumeFluent.FlockerNested<A> withNewFlockerLike(FlockerVolumeSource item);
    public VolumeFluent.FlockerNested<A> editFlocker();
    public A withNewFlocker(String datasetName);
    public GCEPersistentDiskVolumeSource getGcePersistentDisk();
    public A withGcePersistentDisk(GCEPersistentDiskVolumeSource gcePersistentDisk);
    public VolumeFluent.GcePersistentDiskNested<A> withNewGcePersistentDisk();
    public VolumeFluent.GcePersistentDiskNested<A> withNewGcePersistentDiskLike(GCEPersistentDiskVolumeSource item);
    public VolumeFluent.GcePersistentDiskNested<A> editGcePersistentDisk();
    public A withNewGcePersistentDisk(String fsType,Integer partition,String pdName,Boolean readOnly);
    public GitRepoVolumeSource getGitRepo();
    public A withGitRepo(GitRepoVolumeSource gitRepo);
    public VolumeFluent.GitRepoNested<A> withNewGitRepo();
    public VolumeFluent.GitRepoNested<A> withNewGitRepoLike(GitRepoVolumeSource item);
    public VolumeFluent.GitRepoNested<A> editGitRepo();
    public A withNewGitRepo(String directory,String repository,String revision);
    public GlusterfsVolumeSource getGlusterfs();
    public A withGlusterfs(GlusterfsVolumeSource glusterfs);
    public VolumeFluent.GlusterfsNested<A> withNewGlusterfs();
    public VolumeFluent.GlusterfsNested<A> withNewGlusterfsLike(GlusterfsVolumeSource item);
    public VolumeFluent.GlusterfsNested<A> editGlusterfs();
    public A withNewGlusterfs(String endpoints,String path,Boolean readOnly);
    public HostPathVolumeSource getHostPath();
    public A withHostPath(HostPathVolumeSource hostPath);
    public VolumeFluent.HostPathNested<A> withNewHostPath();
    public VolumeFluent.HostPathNested<A> withNewHostPathLike(HostPathVolumeSource item);
    public VolumeFluent.HostPathNested<A> editHostPath();
    public A withNewHostPath(String path);
    public ISCSIVolumeSource getIscsi();
    public A withIscsi(ISCSIVolumeSource iscsi);
    public VolumeFluent.IscsiNested<A> withNewIscsi();
    public VolumeFluent.IscsiNested<A> withNewIscsiLike(ISCSIVolumeSource item);
    public VolumeFluent.IscsiNested<A> editIscsi();
    public DeprecatedDownwardAPIVolumeSource getMetadata();
    public A withMetadata(DeprecatedDownwardAPIVolumeSource metadata);
    public VolumeFluent.MetadataNested<A> withNewMetadata();
    public VolumeFluent.MetadataNested<A> withNewMetadataLike(DeprecatedDownwardAPIVolumeSource item);
    public VolumeFluent.MetadataNested<A> editMetadata();
    public String getName();
    public A withName(String name);
    public NFSVolumeSource getNfs();
    public A withNfs(NFSVolumeSource nfs);
    public VolumeFluent.NfsNested<A> withNewNfs();
    public VolumeFluent.NfsNested<A> withNewNfsLike(NFSVolumeSource item);
    public VolumeFluent.NfsNested<A> editNfs();
    public A withNewNfs(String path,Boolean readOnly,String server);
    public PersistentVolumeClaimVolumeSource getPersistentVolumeClaim();
    public A withPersistentVolumeClaim(PersistentVolumeClaimVolumeSource persistentVolumeClaim);
    public VolumeFluent.PersistentVolumeClaimNested<A> withNewPersistentVolumeClaim();
    public VolumeFluent.PersistentVolumeClaimNested<A> withNewPersistentVolumeClaimLike(PersistentVolumeClaimVolumeSource item);
    public VolumeFluent.PersistentVolumeClaimNested<A> editPersistentVolumeClaim();
    public A withNewPersistentVolumeClaim(String claimName,Boolean readOnly);
    public RBDVolumeSource getRbd();
    public A withRbd(RBDVolumeSource rbd);
    public VolumeFluent.RbdNested<A> withNewRbd();
    public VolumeFluent.RbdNested<A> withNewRbdLike(RBDVolumeSource item);
    public VolumeFluent.RbdNested<A> editRbd();
    public SecretVolumeSource getSecret();
    public A withSecret(SecretVolumeSource secret);
    public VolumeFluent.SecretNested<A> withNewSecret();
    public VolumeFluent.SecretNested<A> withNewSecretLike(SecretVolumeSource item);
    public VolumeFluent.SecretNested<A> editSecret();
    public VsphereVirtualDiskVolumeSource getVsphereVolume();
    public A withVsphereVolume(VsphereVirtualDiskVolumeSource vsphereVolume);
    public VolumeFluent.VsphereVolumeNested<A> withNewVsphereVolume();
    public VolumeFluent.VsphereVolumeNested<A> withNewVsphereVolumeLike(VsphereVirtualDiskVolumeSource item);
    public VolumeFluent.VsphereVolumeNested<A> editVsphereVolume();
    public A withNewVsphereVolume(String fsType,String volumePath);

    public interface AwsElasticBlockStoreNested<N> extends Nested<N>,AWSElasticBlockStoreVolumeSourceFluent<VolumeFluent.AwsElasticBlockStoreNested<N>>{

        
    public N endAwsElasticBlockStore();    public N and();
}
    public interface AzureFileNested<N> extends Nested<N>,AzureFileVolumeSourceFluent<VolumeFluent.AzureFileNested<N>>{

        
    public N endAzureFile();    public N and();
}
    public interface CephfsNested<N> extends Nested<N>,CephFSVolumeSourceFluent<VolumeFluent.CephfsNested<N>>{

        
    public N endCephfs();    public N and();
}
    public interface CinderNested<N> extends Nested<N>,CinderVolumeSourceFluent<VolumeFluent.CinderNested<N>>{

        
    public N and();    public N endCinder();
}
    public interface ConfigMapNested<N> extends Nested<N>,ConfigMapVolumeSourceFluent<VolumeFluent.ConfigMapNested<N>>{

        
    public N and();    public N endConfigMap();
}
    public interface DownwardAPINested<N> extends Nested<N>,DownwardAPIVolumeSourceFluent<VolumeFluent.DownwardAPINested<N>>{

        
    public N endDownwardAPI();    public N and();
}
    public interface EmptyDirNested<N> extends Nested<N>,EmptyDirVolumeSourceFluent<VolumeFluent.EmptyDirNested<N>>{

        
    public N endEmptyDir();    public N and();
}
    public interface FcNested<N> extends Nested<N>,FCVolumeSourceFluent<VolumeFluent.FcNested<N>>{

        
    public N and();    public N endFc();
}
    public interface FlexVolumeNested<N> extends Nested<N>,FlexVolumeSourceFluent<VolumeFluent.FlexVolumeNested<N>>{

        
    public N and();    public N endFlexVolume();
}
    public interface FlockerNested<N> extends Nested<N>,FlockerVolumeSourceFluent<VolumeFluent.FlockerNested<N>>{

        
    public N and();    public N endFlocker();
}
    public interface GcePersistentDiskNested<N> extends Nested<N>,GCEPersistentDiskVolumeSourceFluent<VolumeFluent.GcePersistentDiskNested<N>>{

        
    public N endGcePersistentDisk();    public N and();
}
    public interface GitRepoNested<N> extends Nested<N>,GitRepoVolumeSourceFluent<VolumeFluent.GitRepoNested<N>>{

        
    public N endGitRepo();    public N and();
}
    public interface GlusterfsNested<N> extends Nested<N>,GlusterfsVolumeSourceFluent<VolumeFluent.GlusterfsNested<N>>{

        
    public N and();    public N endGlusterfs();
}
    public interface HostPathNested<N> extends Nested<N>,HostPathVolumeSourceFluent<VolumeFluent.HostPathNested<N>>{

        
    public N and();    public N endHostPath();
}
    public interface IscsiNested<N> extends Nested<N>,ISCSIVolumeSourceFluent<VolumeFluent.IscsiNested<N>>{

        
    public N and();    public N endIscsi();
}
    public interface MetadataNested<N> extends Nested<N>,DeprecatedDownwardAPIVolumeSourceFluent<VolumeFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface NfsNested<N> extends Nested<N>,NFSVolumeSourceFluent<VolumeFluent.NfsNested<N>>{

        
    public N endNfs();    public N and();
}
    public interface PersistentVolumeClaimNested<N> extends Nested<N>,PersistentVolumeClaimVolumeSourceFluent<VolumeFluent.PersistentVolumeClaimNested<N>>{

        
    public N endPersistentVolumeClaim();    public N and();
}
    public interface RbdNested<N> extends Nested<N>,RBDVolumeSourceFluent<VolumeFluent.RbdNested<N>>{

        
    public N and();    public N endRbd();
}
    public interface SecretNested<N> extends Nested<N>,SecretVolumeSourceFluent<VolumeFluent.SecretNested<N>>{

        
    public N and();    public N endSecret();
}
    public interface VsphereVolumeNested<N> extends Nested<N>,VsphereVirtualDiskVolumeSourceFluent<VolumeFluent.VsphereVolumeNested<N>>{

        
    public N endVsphereVolume();    public N and();
}


}
