package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface PodFluent<A extends PodFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public PodFluent.MetadataNested<A> withNewMetadata();
    public PodFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public PodFluent.MetadataNested<A> editMetadata();
    public PodSpec getSpec();
    public A withSpec(PodSpec spec);
    public PodFluent.SpecNested<A> withNewSpec();
    public PodFluent.SpecNested<A> withNewSpecLike(PodSpec item);
    public PodFluent.SpecNested<A> editSpec();
    public PodStatus getStatus();
    public A withStatus(PodStatus status);
    public PodFluent.StatusNested<A> withNewStatus();
    public PodFluent.StatusNested<A> withNewStatusLike(PodStatus item);
    public PodFluent.StatusNested<A> editStatus();

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<PodFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,PodSpecFluent<PodFluent.SpecNested<N>>{

        
    public N endSpec();    public N and();
}
    public interface StatusNested<N> extends Nested<N>,PodStatusFluent<PodFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
