package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import javax.validation.Valid;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public class OAuthClientListFluentImpl<A extends OAuthClientListFluent<A>> extends BaseFluent<A> implements OAuthClientListFluent<A>{

    private String apiVersion;
    private List<VisitableBuilder<? extends OAuthClient,?>> items =  new ArrayList<VisitableBuilder<? extends OAuthClient,?>>();
    private String kind;
    private VisitableBuilder<? extends ListMeta,?> metadata;

    public OAuthClientListFluentImpl(){
    }
    public OAuthClientListFluentImpl(OAuthClientList instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public A addToItems(OAuthClient... items){
            for (OAuthClient item : items) {OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(OAuthClient... items){
            for (OAuthClient item : items) {OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public List<OAuthClient> getItems(){
            return build(items);
    }

    public A withItems(List<OAuthClient> items){
            this.items.clear();
            if (items != null) {for (OAuthClient item : items){this.addToItems(item);}} return (A) this;
    }

    public A withItems(OAuthClient... items){
            this.items.clear(); if (items != null) {for (OAuthClient item :items){ this.addToItems(item);}} return (A) this;
    }

    public OAuthClientListFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public OAuthClientListFluent.ItemsNested<A> addNewItemLike(OAuthClient item){
            return new ItemsNestedImpl(item);
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public ListMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ListMeta metadata){
            if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public OAuthClientListFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public OAuthClientListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item){
            return new MetadataNestedImpl(item);
    }

    public OAuthClientListFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public A withNewMetadata(String resourceVersion,String selfLink){
            return (A)withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OAuthClientListFluentImpl that = (OAuthClientListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends OAuthClientFluentImpl<OAuthClientListFluent.ItemsNested<N>> implements OAuthClientListFluent.ItemsNested<N>,Nested<N>{

            private final OAuthClientBuilder builder;
    
            ItemsNestedImpl(){
                    this.builder = new OAuthClientBuilder(this);
            }
            ItemsNestedImpl(OAuthClient item){
                    this.builder = new OAuthClientBuilder(this, item);
            }
    
    public N endItem(){
            return and();
    }
    public N and(){
            return (N) OAuthClientListFluentImpl.this.addToItems(builder.build());
    }

}
    public class MetadataNestedImpl<N> extends ListMetaFluentImpl<OAuthClientListFluent.MetadataNested<N>> implements OAuthClientListFluent.MetadataNested<N>,Nested<N>{

            private final ListMetaBuilder builder;
    
            MetadataNestedImpl(){
                    this.builder = new ListMetaBuilder(this);
            }
            MetadataNestedImpl(ListMeta item){
                    this.builder = new ListMetaBuilder(this, item);
            }
    
    public N and(){
            return (N) OAuthClientListFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}


}
